<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("../../core/controllers/imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("../../core/controllers/imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'sessions';
        $this->shcontrollname = 'Sessions';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'Board'; //controller name or tab name
        $active[1] = 'sessions'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'addsession';
                break;
            case 'archiveshowall':$active[2] = 'archivesess';
                break;

            default :$active[2] = 'index';
                break;
        }
        $this->active = $active;


        //here will call all php pages
        require_once("../../core/controllers/_header.php");
        require_once("../../core/controllers/_sidebar.php");
        require_once("../../core/controllers/_leftsidebar.php");
        require_once("../../core/controllers/_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $userId = $_SESSION['user_id'];
        $this->smarty->assign('userId', $userId);



        ##all members in the council
        //$councilMembers = R::findAll('councilstaff');
        $councilMembers = R::getAll('SELECT *  FROM awusers WHERE positionid in (? , ? , ? )', [1 , 2 , 3]);
        
//        foreach ($councilMembers as $member) {
//            $userId = $member->userid;
//            $user = R::getRow('SELECT * FROM awusers WHERE user_id = ? ', [$userId]);
//            $member->name = $user['name'];
//        }

        ## all non discussed requests
        $requests = R::findAll('brequests', 'status = ? ', [1]);


        $lastSession = R::findLast('bsession');
        $new = 0;

        if ($lastSession != NULL) {
            if ($lastSession->status == 0) {    ##  there is non complete session so load it
                $session = $lastSession;
                foreach ($councilMembers as $member) {
                    $sessionMember = R::findOne('bsessionmembers', 'sessionid = ?  and memberid = ?', [$session->id, $member['user_id']]);

                    if ($sessionMember) {
                        $member['attend'] = 1;
                    } else {
                        $member['attend'] = 0;
                    }
                }
            } else {    ## create new session
                $new = 1;
            }
        } else {
            $new = 1;
        }

        if ($new == 1) {
            $session = R::dispense('bsession');
            $session->memberid = $userId;

            try {
                $sessionid = R::store($session);
            } catch (Exception $ex) {

            }
            $sessionmember = R::dispense('bsessionmembers');

            $sessionmembers = array();
            foreach ($councilMembers as $member) {
                $sessionmember = R::dispense('bsessionmembers');
                $sessionmember->sessionid = $sessionid;
                $sessionmember->memberid = $member['user_id'];
                $sessionmembers[] = $sessionmember;
            }
            R::begin();
            try {
                R::storeAll($sessionmembers);
                R::commit();
            } catch (Exception $ex) {
                R::rollback();
            }
        }

        $this->smarty->assign('new', $new);
        $this->smarty->assign('session', $session);
        $this->smarty->assign('councilMembers', $councilMembers);
        $this->smarty->assign('allRequests', $requests);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('addsession.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function savesession() {         ## move session to archive
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        ## close session
        $sessionId = filter_input(INPUT_POST, 'sessionId');
        $session = R::load('bsession', $sessionId);
        $session->status = 1;
        $session->date = date('Y-m-d');

        ## close discussed requests
        $requests = R::findAll('brequests', 'status = ? and delay = ? ', [1, 0]);

        foreach ($requests as $request) {
            $request->status = 2;
            $request->sessionid = $sessionId;
            $request->delay = 0;
        }
        $requestsDelayed = R::findAll('brequests', 'status = ? and delay = ? ', [1, 1]);
        foreach ($requestsDelayed as $request) {
            $request->delay = 0;
        }
        R::begin();
        try {
            R::store($session);
            R::storeAll($requests);
            R::storeAll($requestsDelayed);
            R::commit();
            echo '/controllers/' . $this->controllname . '.php?ac=archiveshowall';
        } catch (Exception $e) {
            R::rollback();
        }
    }

    public function archiveshowall() {    ## show all archived sessions
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $allSessions = R::findAll('bsession', 'status = ? ', [1]);
        $this->smarty->assign('allSessions', $allSessions);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('showsessions.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function requestDetails() {      ## show request details model  in case of creating session
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $requestId = filter_input(INPUT_POST, 'requestId');
        $sessionId = filter_input(INPUT_POST, 'sessionId');

        $request = R::load('brequests', $requestId);
        $this->smarty->assign('request', $request);

        $members = R::findAll('bsessionmembers', 'sessionid = ? ', [$sessionId]);
        foreach ($members as $member) {
            ## members who will give opinion
            $userId = $member->memberid;
            $user = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$userId]);
            $member->memberName = $user['name'];
            $userOpinion = R::getRow('SELECT openion FROM bmemberopenion WHERE sessionmemberid = ? and requestid = ? ', [$member->id, $requestId]);
            $member->openion = $userOpinion['openion'];
        }
        $this->smarty->assign('sessionMembers', $members);
        //call other class with other content

        $this->smarty->display('members.html');
    }

    public function requestDetailsArchive() {      ## show request details model  in case of archived session
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $requestId = filter_input(INPUT_POST, 'requestId');
        $sessionId = filter_input(INPUT_POST, 'sessionId');

        $request = R::load('brequests', $requestId);
        $this->smarty->assign('request', $request);

        $members = R::findAll('bsessionmembers', 'sessionid = ? ', [$sessionId]);
        foreach ($members as $member) {
            ## members who will give opinion
            $userId = $member->memberid;
            $user = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$userId]);
            $member->memberName = $user['name'];
            $userOpinion = R::getRow('SELECT openion FROM bmemberopenion WHERE sessionmemberid = ? and requestid = ? ', [$member->id, $requestId]);
            $member->openion = $userOpinion['openion'];
        }
        $this->smarty->assign('sessionMembers', $members);
        //call other class with other content

        $this->smarty->display('session_model.html');
    }

    public function sessiondetails() {
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $sessionId = filter_input(INPUT_GET, 'id');

        $session = R::load('bsession', $sessionId);
        $this->smarty->assign('session', $session);

        $members = R::findAll('bsessionmembers', 'sessionid = ? ', [$sessionId]);
        foreach ($members as $member) {
            ## members who will give opinion
            $userId = $member->memberid;
            $user = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$userId]);
            $member->memberName = $user['name'];
        }
        $this->smarty->assign('sessionMembers', $members);

        $requests = R::findAll('brequests', 'sessionid = ? ', [$sessionId]);
        $this->smarty->assign('requests', $requests);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('sessiondetails.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addsessionmember() {    ## mark member as  attend the session
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $sessionId = filter_input(INPUT_POST, 'sessionId');
        $memberId = filter_input(INPUT_POST, 'memberId');

        $sessionMember = R::dispense('bsessionmembers');
        $sessionMember->sessionid = $sessionId;
        $sessionMember->memberid = $memberId;
        try {
            R::store($sessionMember);
            echo '111';
        } catch (Exception $e) {
            echo 'member cant be inserted';
        }
    }

    public function removesessionmember() {     ## mark member as not attend the session
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $sessionId = filter_input(INPUT_POST, 'sessionId');
        $memberId = filter_input(INPUT_POST, 'memberId');

        $sessionMember = R::findOne('bsessionmembers', 'sessionid = ?  and memberid = ?', [$sessionId, $memberId]);
        try {
            R::trash($sessionMember);
        } catch (Exception $e) {

        }
    }

    public function delay() {            ## mark request as delayed
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $requestId = filter_input(INPUT_POST, 'requestId');

        $request = R::load('brequests', $requestId);
        $request->delay = 1;
        try {
            R::store($request);
        } catch (Exception $e) {

        }
    }

    public function notdelay() {       ## mark request as not delayed
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $requestId = filter_input(INPUT_POST, 'requestId');

        $request = R::load('brequests', $requestId);
        $request->delay = 0;
        try {
            R::store($request);
        } catch (Exception $e) {

        }
    }

    public function saveopinion() {    ## save member opion on certain request
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $requestId = filter_input(INPUT_POST, 'requestId');
        $sessionMemberId = filter_input(INPUT_POST, 'sessionMemberId');
        $opinion = filter_input(INPUT_POST, 'opinion');

        $bmemberopenion = R::findOne('bmemberopenion', 'requestid = ? and  sessionmemberid = ? ', [$requestId, $sessionMemberId]);
        if ($bmemberopenion) {
            $bmemberopenion->openion = $opinion;
            try {
                R::store($bmemberopenion);
            } catch (Exception $e) {

            }
        } else {
            $bmemberopenion = R::dispense('bmemberopenion');
            $bmemberopenion->requestid = $requestId;
            $bmemberopenion->sessionmemberid = $sessionMemberId;
            $bmemberopenion->openion = $opinion;
            try {
                R::store($bmemberopenion);
            } catch (Exception $e) {

            }
        }
    }

    public function savedecision() {          ## save council  decision   on certain request
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $requestId = filter_input(INPUT_POST, 'requestId');
        $decision = filter_input(INPUT_POST, 'decision');

        $request = R::load('brequests', $requestId);
        $request->decision = $decision;
        try {
            R::store($request);
        } catch (Exception $e) {

        }
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
