<?php

require_once("imp/_imp.php");

class Controllers
{
    public $smarty;
    public $host_url;
    public $control_name;
    public $display_control_name;
    public $active;
    public $time;
    public $today;
    public $patient_id;

    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->host_url = $hosturl;

        $this->control_name = 'appointments';
        $this->display_control_name = 'appointments';
        $this->smarty->assign('control_name', $this->control_name);
        $this->smarty->assign('display_control_name', $this->display_control_name);

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $active[0] = $this->control_name;
        $active[1] = $this->control_name;
        if ($acty === '') {
            $active[2] = $this->control_name . 'add';
        } else {
            $active[2] = $this->control_name . 'show';
        }

        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        $this->smarty->display('appointments/show.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function events()
    {
        autho::checkautho($this->host_url);

        $start = filter_input(INPUT_POST, 'start');
        $end = filter_input(INPUT_POST, 'end');
        $start_date = date('Y-m-d', strtotime($start));
        $end_date = date('Y-m-d', strtotime($end));

        $appointments = [];

        // get vacations dates
        $vacations = R::findAll('vacations', 'vacation_date >= date("' . $start_date . '") and vacation_date <= date("' . $end_date . '") ORDER BY vacation_date ASC');
        foreach ($vacations as $vacation) {
            $appointments[] = [
                'id' => $vacation->id,
                'title' => $vacation->vacation_reason,
                'start' => date('Y-m-d', strtotime($vacation->vacation_date)),
                'display' => 'background',
                'color' => '#f56954',
                'allDay' => true,
            ];
        }

        // get operations dates
        $operations = R::findAll('op_wait_list', 'opdate >= date("' . $start_date . '") and opdate <= date("' . $end_date . '") and deleted = 0');
        foreach ($operations as $operation) {
            $patient_info = R::findOne('patients', 'id = ?', [$operation->patientid]);
            $operation_info = R::findOne('operation', 'id = ?', [$operation->operation]);
            $appointments[] = [
                'id' => $operation->id,
                'title' => $patient_info ? $patient_info->wifename : 'No name',
                'extendedProps' => ['description' => $operation_info->title],
                'start' => date('Y-m-d', strtotime($operation->opdate)),
            ];
        }

        // count visits for each visit date
        $visits_count = R::getAll('select visitdate as visit_date,COUNT(visitdate) as visit_count from visits where deleted = 0 and visitdate >= date("' . $start_date . '") and visitdate <= date("' . $end_date . '") group by visitdate');
        foreach ($visits_count as $visit_count) {
            $appointments[] = [
                'id' => mt_rand(1,20),
                'title' => 'Visits No: ' . $visit_count['visit_count'],
                'start' => $visit_count['visit_date'],
                'color' => '#1c8bc5',
                'allDay' => true,
            ];
        }

        echo json_encode($appointments);
    }

    public function __destruct()
    {
        R::close();
    }

}
