<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in structure of file
 */

require_once("imp/_imp.php");

class Controllers
{

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of control to known
        $this->controllname = 'growth_chart';
        $this->shcontrollname = 'growth_chart';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'growth_chart'; //controller name or tab name
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
        require_once("_patientdata.php");
    }

    public function index()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_GET, "patientid");
        if (empty($patientId)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);

        $patient_info = R::findOne('patients', 'id = ?', [$patientId]);
        if ($patient_info) {
            $diff = date_diff(date_create($patient_info->dateofbirth), date_create('today'));
            $this->smarty->assign('patient_age', $diff->y . 'Y , ' . $diff->m . 'M , ' . $diff->d . 'D  ');
        }

        $growth_data = R::findAll('growth','patient_id = ? order by growth_date desc',[$patientId]);
        list($patient_height_arr,$patient_weight_arr,$patient_bmi_arr) = [[],[]];
        list($patient_length_weight_arr,$patient_age_head_arr,$patient_age_length_arr,$patient_age_weight_arr) = [[],[],[],[]];
        foreach ($growth_data as $growth_datum){
            $growth_datum->growth_date = date("Y/m/d", strtotime($growth_datum->growth_date));
            $growth_date = strtotime($growth_datum->growth_date);
            $birth_day = strtotime($patient_info->dateofbirth);
            $totalSecondsDiff = abs($growth_date-$birth_day);
            $diff_months = $totalSecondsDiff/60/60/24/30;

            // cdc only run after 2 years old
            if($growth_datum->length > 0 & $diff_months >= 24 & $diff_months <= 240){
                $patient_height_arr[] = [round($diff_months/12,2),(int)$growth_datum->length];
            }
            if($growth_datum->weight > 0 & $diff_months >= 24 & $diff_months <= 240){
                $patient_weight_arr[] = [round($diff_months/12,2),(int)$growth_datum->weight];
            }
            if($growth_datum->bmi > 0 & $diff_months >= 24 & $diff_months <= 240.5){
                $patient_bmi_arr[] = [round($diff_months/12,2),(int)$growth_datum->bmi];
            }

            // who <= 24 month
            if($growth_datum->length > 0 & $growth_datum->weight > 0 & $diff_months <= 24 & $diff_months >= 0){
                $patient_length_weight_arr[] = [(int)$growth_datum->length,(int)$growth_datum->weight];
            }
            if($growth_datum->head > 0 & $diff_months <= 24 & $diff_months >= 0){
                $patient_age_head_arr[] = [$diff_months,(int)$growth_datum->head];
            }
            if($growth_datum->length > 0 & $diff_months <= 24 & $diff_months >= 0){
                $patient_age_length_arr[] = [$diff_months,(int)$growth_datum->length];
            }
            if($growth_datum->weight > 0 & $diff_months <= 24 & $diff_months >= 0){
                $patient_age_weight_arr[] = [$diff_months,(int)$growth_datum->weight];
            }

        }
        $this->smarty->assign('growth_data',$growth_data);

        $this->smarty->assign('growth_chart_data', [
            'height' => json_encode($patient_height_arr),
            'weight' => json_encode($patient_weight_arr),
            'bmi' => json_encode($patient_bmi_arr),
            'length_weight' => json_encode($patient_length_weight_arr),
            'age_head' => json_encode($patient_age_head_arr),
            'age_length' => json_encode($patient_age_length_arr),
            'age_weight' => json_encode($patient_age_weight_arr),
        ]);

        $this->smarty->display('growth_chart/show.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function newRow()
    {
        autho::checkautho($this->hosturl);

        $patientId = filter_input(INPUT_POST, "patient_id");
        $today = date('Y-m-d');
        try {
            $growth_obj = R::dispense('growth');
            $growth_obj->patientId = $patientId;
            $growth_obj->growth_date = $today;
            $growth_obj->length = 0;
            $growth_obj->weight = 0;
            $growth_obj->head = 0;
            $growth_obj->bmi = 0;

            $id = R::store($growth_obj);
            $growth_obj->id = $id;

            $growth_obj->growth_date = date("Y/m/d", strtotime($growth_obj->growth_date));

            $this->smarty->assign('growth_obj', $growth_obj);
            $this->smarty->display('growth_chart/new_row.tpl');
        } catch (Exception $e) {
            echo $e->getMessage();
        }
    }

    public function update() {

        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, "id");
        $table_name = filter_input(INPUT_POST, "tableName");
        $col_name = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");

        $is_date = filter_input(INPUT_POST, "dated");
        if ((int)$is_date === 1) {
            $value = date("Y-m-d", strtotime($value));
        }

        try {
            $new_obj = R::load($table_name, $id);
            $new_obj->$col_name = $value;
            R::store($new_obj);
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function del() {
        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, 'id');
        $tableName = filter_input(INPUT_POST, 'tableName');

        try {
            $obj = R::load($tableName, $id);
            R::trash($obj);
            echo 1;
        } catch (Exception $ex) {
            echo -1;
        }
    }

    public function __destruct()
    {
        R::close();
    }

}
