<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */
require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $patientid;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'gtimage';
        $this->shcontrollname = 'Home';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'GT Image'; //controller name or tab name
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
        $this->patientid = patientdata::patientid();
    }

    //here the frist page and
    //the frist action in this class

    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $doctorid = $_SESSION['user_id'];
        $doctorData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $this->smarty->assign('doctorData', $doctorData);

        $today = date("Y/m/d");
        $this->smarty->assign('today', $today);

        $patientid = filter_input(INPUT_GET, "patientid");
        if (empty($this->patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientid', $this->patientid);
        $patientData = R::load('patients', $this->patientid);
        $this->smarty->assign('patientName', $patientData->wifename);
        $type;
        $wifeType;
        if (!empty($patientData->wiftypeid)) {
            $type = R::load('wifetypes', $patientData->wiftypeid);
            if (!empty($type)) {
                $wifeType = $type->title;
            }
        } else {
            $wifeType = " ";
        }
        $this->smarty->assign('patientType', $wifeType);

        $ProgramesettingData = R::findone('programesetting');
        if ($ProgramesettingData->programview == 1) {
            $pic = '1.jpg';
        } else {
            $pic = $ProgramesettingData->gtimage;
        }


        $allGData = R::findAll('gtimage', 'patientid = ?', [$this->patientid]);
        /* if(empty($allGData))
          { */
        $gData = R::dispense('gtimage');
        $gData->gdate = $today;
        $gData->patientid = $this->patientid;
        $gData->doctorid = $doctorid;
        $gData->pic = $pic;
        $gData->programview = $ProgramesettingData->programview;
        $gData->del = 0;
        $gid = R::store($gData);
        $allGData = R::load('gtimage', $gid);
        $this->smarty->assign("itrcount", 0);
        //}
        /*        else
          {
          $lastGData = R::findOne('gtimage','patientid = ? and del = 0 order by id desc limit 1',[$this->patientid]);
          R::exec('insert into gtimage (gdate,patientid,doctorid,comment,del) select "'.$today.'",patientid,'.$doctorid.',comment,0 from gtimage where id = '.$lastGData->id.'');
          $gdataid = R::getInsertID();
          $allGData = R::load('gtimage',$gdataid);

          $prevGtDetail = R::findAll('gtdetail','gtid = ? and del = 0',[$lastGData->id]);

          foreach ($prevGtDetail as $detail)
          {
          R::exec('insert into gtdetail (gtid,posx,posy,width,height,imgno,del) select '.$gdataid.',posx,posy,width,height,imgno,del from gtdetail where id = '.$detail->id.'');
          }
          $allGtDetail = R::findAll('gtdetail','gtid = ? and del = 0',[$allGData->id]);
          $this->smarty->assign('allGtDetail', $allGtDetail);

          $allData = R::findAll('gtdetail','gtid = ?',[$allGData->id]);
          $this->smarty->assign("itrcount",count($allData));
          } */
        $this->smarty->assign('allGData', $allGData);

        header('Location:' . $this->hosturl . '/controllers/gtimage.php?ac=add&patientid=' . $this->patientid . '&id=' . $allGData->id);
    }

    public function show() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $doctorid = $_SESSION['user_id'];
        $doctorData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $this->smarty->assign('doctorData', $doctorData);

        $today = date("Y/m/d");
        $this->smarty->assign('today', $today);

        $patientid = filter_input(INPUT_GET, "patientid");
        if (empty($this->patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientid', $this->patientid);
        $patientData = R::load('patients', $this->patientid);
        $this->smarty->assign('patientName', $patientData->wifename);

        $allGtImage = R::findAll('gtimage', 'patientid = ? and del = 0', [$this->patientid]);
        $this->smarty->assign('allGtImage', $allGtImage);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->display('gtimage/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function update() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_POST, "patientId");
        $gtId = filter_input(INPUT_POST, "gtId");
        $posx = filter_input(INPUT_POST, "x");
        $posy = filter_input(INPUT_POST, "y");
        $width = filter_input(INPUT_POST, "w");
        $height = filter_input(INPUT_POST, "h");
        $imgno = filter_input(INPUT_POST, "no");
        $comment = filter_input(INPUT_POST, "comment");
        $id = filter_input(INPUT_POST, "id");

        if ($id == 0) {
            $myData = R::dispense('gtdetail');
        } else {
            $myData = R::load('gtdetail', $id);
        }
        $myData->gtid = $gtId;
        $myData->posx = $posx;
        $myData->posy = $posy;
        $myData->width = $width;
        $myData->height = $height;
        $myData->imgno = $imgno;
        $myData->comment = $comment;
        $myData->del = 0;

        $did = R::store($myData);
        echo $did;
    }

    public function updateSize() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $width = filter_input(INPUT_POST, "w");
        $height = filter_input(INPUT_POST, "h");
        $id = filter_input(INPUT_POST, "id");

        $myData = R::load('gtdetail', $id);

        $myData->width = $width;
        $myData->height = $height;

        $did = R::store($myData);
        echo $did;
    }

    public function updateComment() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $value = filter_input(INPUT_POST, "value");
        $gtId = filter_input(INPUT_POST, "gtId");

        $myData = R::load('gtimage', $gtId);

        $myData->comment = $value;

        $did = R::store($myData);
        echo $did;
    }

    public function updateComentC() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $value = filter_input(INPUT_POST, "value");
        $id = filter_input(INPUT_POST, "id");

        try {
            $myData = R::load('gtdetail', $id);
            $myData->comment = $value;
            R::store($myData);
            echo 1;
        } catch (Exception $ex) {
            echo -1;
        }
    }

    public function delData() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, "id");
        $gtid = filter_input(INPUT_GET, "gtid");
        $patientid = filter_input(INPUT_GET, "patientid");

        if (!empty($id)) {
            $myData = R::load(gtdetail, $id);
            $myData->del = 1;
            $myid = R::store($myData);
            $gtid = $myData->gtid;
        } else {
            $myData = R::findAll("gtdetail", 'gtid = ?', [$gtid]);
            foreach ($myData as $data) {
                $data->del = 1;
                $myid = R::store($data);
            }
        }
        header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=add&patientid=' . $patientid . '&id=' . $gtid);
    }

    public function showdata() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $doctorid = $_SESSION['user_id'];
        $doctorData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $this->smarty->assign('doctorData', $doctorData);

        $today = date("Y/m/d");
        $this->smarty->assign('today', $today);

        $patientid = filter_input(INPUT_GET, "patientid");
        $id = filter_input(INPUT_GET, "id");
        if (empty($this->patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientid', $this->patientid);
        $patientData = R::load('patients', $this->patientid);
        $this->smarty->assign('patientName', $patientData->wifename);
        $type;
        $wifeType;
        if (!empty($patientData->wiftypeid)) {
            $type = R::load('wifetypes', $patientData->wiftypeid);
            if (!empty($type)) {
                $wifeType = $type->title;
            }
        } else {
            $wifeType = " ";
        }
        $this->smarty->assign('patientType', $wifeType);


        $gtData = R::load('gtimage', $id);

        $allGtDetail = R::findAll('gtdetail', 'gtid = ? and del = 0', [$gtData->id]);
        $this->smarty->assign('allGtDetail', $allGtDetail);

        $this->smarty->assign('allGData', $gtData);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->display('gtimage/showdata.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $doctorid = $_SESSION['user_id'];
        $doctorData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $this->smarty->assign('doctorData', $doctorData);

        $today = date("Y/m/d");
        $this->smarty->assign('today', $today);

        $patientid = filter_input(INPUT_GET, "patientid");
        $id = filter_input(INPUT_GET, "id");     ## gtimage id 
        if (empty($this->patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientid', $this->patientid);
        $patientData = R::load('patients', $this->patientid);
        $this->smarty->assign('patientName', $patientData->wifename);
        $type;
        $wifeType;
        if (!empty($patientData->wiftypeid)) {
            $type = R::load('wifetypes', $patientData->wiftypeid);
            if (!empty($type)) {
                $wifeType = $type->title;
            }
        } else {
            $wifeType = " ";
        }
        $this->smarty->assign('patientType', $wifeType);


        $gtData = R::findOne('gtimage', 'id = ? and patientid = ?', [$id, $patientid]);
        $allGtDetail = '';
        if (!empty($gtData)) {
            $allGtDetail = R::findAll('gtdetail', 'gtid = ? and del = 0', [$gtData->id]);

            if (empty($allGtDetail)) {
                $this->smarty->assign("itrcount", 0);
            } else {
                $allData = R::findAll('gtdetail', 'gtid = ?', [$gtData->id]);
                $this->smarty->assign("itrcount", count($allData));
            }
        } else {
            $this->smarty->assign("itrcount", 0);
        }

        $gtimageExist = 0;
        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $this->smarty->assign('allGData', $gtData);
        $this->smarty->assign('allGtDetail', $allGtDetail);
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->display('gtimage/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function delRow() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $gtid = filter_input(INPUT_GET, "gtid");
        $patientid = filter_input(INPUT_GET, "patientid");

        $gData = R::load('gtimage', $gtid);
        $gData->del = 1;
        R::store($gData);

        $myData = R::findAll("gtdetail", 'gtid = ?', [$gtid]);
        foreach ($myData as $data) {
            $data->del = 1;
            $myid = R::store($data);
        }


        header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
    }

    public function onesetup() {

        //check login
        autho::checkautho($this->hosturl);

        try {
            //delete all but with only default
            #1 clean roles only managment
            #2 clean menu only default
            #3 clean controls only default
            #4 users clean users
            #delete all menus
            $menus = R::findAll('awmenu', 'id > 15');
            #delete from awrolemenu
            foreach ($menus as $one) {
                //get propes
                $rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
                R::trashAll($rolemenu);
            }
            R::trashAll($menus);
            #delete controles
            $controlls = R::findAll('awcontroll', 'id > 4 and id < 18');
            foreach ($controlls as $one) {
                //get propes
                $inprop = R::findAll('awcontrollprop', 'awcontroll_id = ?', [$one->id]);
                #delete from awrolecontroleprop
                foreach ($inprop as $one) {
                    //get propes
                    $roleprop = R::findAll('awrolecontrollprop', 'controllprop_id = ?', [$one->id]);
                    R::trashAll($roleprop);
                }
                R::trashAll($inprop);
            }
            R::trashAll($controlls);
            #delete othre roles
            $roles = R::findAll('awrole', 'id > 1');
            R::trashAll($roles);
            #delete other users
            //$users = R::findAll('awusers', 'user_id > 1');
            //R::exec('Delete from awusers where user_id > 1');
            //R::trashAll($users);
            ############################
            //new one
            $menusx = R::findAll('awmenu', ' id = 4 or id = 5 or id = 7 or id = 8 or id = 10 or id = 11 or id = 13 or id = 14 or id = 15 ');
            #delete from awrolemenu
            foreach ($menusx as $one) {
                //get propes
                $rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
                R::trashAll($rolemenu);
            }
            R::trashAll($menusx);

            print_r('trash all , install is good');
        } catch (Exception $ex) {
            print_r('something go wrong  , try again');
        }
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
