<?php

function saveTrackingRecord($patient_id, $device_id, $target_id, $target_table, $control) {
    $obj = R::xdispense('device_tracking');
    $obj->patient_id = $patient_id;
    $obj->device_id = $device_id;
    $obj->visit_date = date('Y-m-d');
    $obj->visit_time = date("H:i:s");
    $obj->target_id = $target_id;
    $obj->target_table = $target_table;
    $obj->control = $control;
    $obj->user_id = $_SESSION['user_id'];
    $obj->deleted = 0;

    try {

        $insert = R::store($obj);
    } catch (Exception $ex) {
        echo $ex;
    }
}

function getPatientId($patientNo) {
    $patient = R::findOne('patients', ' deleted = 0  and  statusno = ?  ', [$patientNo]);
    if ($patient->id > 0) {
        return $patient->id;
    } else {
        return 0;
    }
}

function getDeviceId($deviceNo) {
    $device = R::findOne('devices', ' deleted = 0  and  device_name = ?  ', [$deviceNo]);
    if ($device->id > 0) {
        return $device->id;
    } else {
        return 0;
    }
}

function getPatientNo($patientId) {
    $patient = R::load('patients', $patientId);
    if ($patient->id > 0) {
        return $patient->statusno;
    } else {
        return 0;
    }
}

function getPatientPhone($patientId) {
    $patient = R::load('patients', $patientId);
    $phone = '';
    if ($patient->id > 0 && $patient->phone != '' && $patient->phone != null) {
        $phone = $patient->phone;
    } else if ($patient->id > 0 && $patient->mobile != '' && $patient->mobile != null) {
        $phone = $patient->mobile;
    }
    return $phone;
}

function sendSms($patientId, $message) {
    $phoneNo = getPatientPhone($patientId);
    // send to Egypt only
    $recipient = ltrim($phoneNo, "2");
    $recipient = ltrim($recipient, "+2");
    $recipient = ltrim($recipient, "02");
    $recipient = ltrim($recipient, "002");
    $recipient = ltrim($recipient, "0");
    $phoneNoWithCode = "20" . ($recipient);

    $data = array(
        "recipient" => $phoneNoWithCode
        , "sender_id" => "DrMhmodGoma"
        , "type" => "plain"
        , "message" => $message
    );

    $buildQuery = http_build_query($data);
    $requestUrl = "https://bulk.whysms.com/api/v3/sms/send/?" . $buildQuery;

    $curl = curl_init();

    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
    curl_setopt_array($curl, array(
        CURLOPT_URL => $requestUrl,
        CURLOPT_HEADER => false,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_HTTPHEADER => array('Content-Type:application/json'
            , 'Accept: application/json'
            , 'Authorization: Bearer 40|tbtaEm4E8gdINZE8sG455GWzGmhJYIkRDDFW54pT'
            , 'Content-Length:0')
    ));

    $response = curl_exec($curl);

    // Close cURL session
    curl_close($curl);
    $res = json_decode($response);
    if ($res->success) {
        print('success');
        //    return $res->success;
    } else {
        print('error');
        //  return $res->error->message;
    }
}
