<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("../../core/controllers/imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("../../core/controllers/imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'requests';
        $this->shcontrollname = 'Requests';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element

        $active[0] = 'Board'; //controller name or tab name
        $active[1] = 'Request'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'addrequests';
                break;
            case 'showall':$active[2] = 'showrequests';
                break;
            case 'archiveshowall':$active[2] = 'archive';
                break;
            default :$active[2] = 'index';
                break;
        }
        $this->active = $active;

        //here will call all php pages
        require_once("../../core/controllers/_header.php");
        require_once("../../core/controllers/_sidebar.php");
        require_once("../../core/controllers/_leftsidebar.php");
        require_once("../../core/controllers/_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $userId = $_SESSION['user_id'];
        $this->smarty->assign('userId', $userId);

        $lastRequest = R::findLast('brequests', 'memberId = ? ', [$userId]);
        $new = 0;
        if ($lastRequest != NULL) {
            if ($lastRequest->status == 0) {    // there is non complete request so load it
                $request = $lastRequest;
            } else {    // create new request
                $new = 1;
            }
        } else {
            $new = 1;
        }

        if ($new == 1) {
            $request = R::dispense('brequests');
            $request->memberid = $userId;
            try {
                R::store($request);
            } catch (Exception $ex) {

            }
        }

        $this->smarty->assign('request', $request);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('addrequest.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function update() {      ## auto save entered values
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show
        $id = filter_input(INPUT_POST, 'id');
        $value = filter_input(INPUT_POST, 'value');
        $tableName = filter_input(INPUT_POST, 'tableName');
        $colName = filter_input(INPUT_POST, 'colName');

        $obj = R::load($tableName, $id);
        $obj->$colName = $value;
        try {
            R::store($obj);
        } catch (Exception $e) {

        }
    }

    public function sendrequest() {     ## send request and mark it as complete
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $requestId = filter_input(INPUT_POST, 'requestId');
        $request = R::load('brequests', $requestId);
        $request->status = 1;
        $request->date = date('Y-m-d');
        try {
            R::store($request);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=showall');
        } catch (Exception $e) {

        }
    }

    public function showall() {       ## show all requests but not archive
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $userId = $_SESSION['user_id'];
        $user = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$userId]);
        $this->smarty->assign('loginUserName', $user['name']);


        $allRequests = R::findAll('brequests', 'status = ? ', [1]);
        $this->smarty->assign('allRequests', $allRequests);
        $this->smarty->assign('isArchived', 0);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('showrequests.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function archiveshowall() {    ##   show all archived requests
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $userId = $_SESSION['user_id'];
        $user = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$userId]);
        $this->smarty->assign('loginUserName', $user['name']);

        $allRequests = R::findAll('brequests', 'status = ? ', [2]);
        $this->smarty->assign('allRequests', $allRequests);
        $this->smarty->assign('isArchived', 1);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('showrequests.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function requestDetails() {      ## show request details model
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $requestId = filter_input(INPUT_POST, 'requestId');

        $request = R::load('brequests', $requestId);



        $this->smarty->assign('request', $request);

        //call other class with other content

        $this->smarty->display('requestdetails.html');
    }

    public function requestcomments() {      ## show request details model
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $userId = $_SESSION['user_id'];
        $this->smarty->assign('userId', $userId);



        $requestId = filter_input(INPUT_POST, 'requestId');
        ## get all primary  comments
        $comments = R::findAll('bcomments', 'requestid = ?  and relatedcommentid = ?', [$requestId, 0]);
        foreach ($comments as $comment) {
            ## get all secondary comments that related to primary one
            $relatedComments = R::findAll('bcomments', 'requestid = ?  and relatedcommentid = ?', [$requestId, $comment->id]);
            foreach ($relatedComments as $relatedComment) {
                ##user who wrote the comment
                $userId = $relatedComment->memberid;
                $user = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$userId]);
                $relatedComment->memberName = $user['name'];
            }
            $comment->childs = $relatedComments;
            ##user who wrote the comment
            $userId = $comment->memberid;
            $user = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$userId]);
            $comment->memberName = $user['name'];
        }

        $this->smarty->assign('comments', $comments);
        //call other class with other content

        $this->smarty->display('comments.html');
    }

    public function addcomment() {           ## add comment on acertain request
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show

        $userId = $_SESSION['user_id'];
        $comment = filter_input(INPUT_POST, 'comment');
        $related = filter_input(INPUT_POST, 'related');
        $requestId = filter_input(INPUT_POST, 'requestId');

        $comments = R::dispense('bcomments');
        $comments->memberid = $userId;
        $comments->requestid = $requestId;
        $comments->comment = $comment;
        $comments->relatedcommentid = $related;
        try {
            echo R::store($comments);
        } catch (Exception $e) {
            echo 'member cant be inserted';
        }
    }

    public function deletecomment() {           ## delete comment on acertain request
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        //here will load the menu show

        $commentId = filter_input(INPUT_POST, 'commentId');


        $comment = R::load('bcomments', $commentId);
        if ($comment->relatedcommentid == 0) {
            $relatedComments = R::findAll('bcomments', 'relatedcommentid = ?', [$commentId]);
            try {
                R::trashAll($relatedComments);
                echo 0;
            } catch (Exception $e) {
                echo 'member cant be deleted';
            }
        }

        try {
            R::trash($comment);
            echo 1;
        } catch (Exception $e) {
            echo 'member cant be deleted';
        }
    }

    public function requestDetailsArchive() {      ## show request details model
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $requestId = filter_input(INPUT_POST, 'requestId');
        $request = R::load('brequests', $requestId);
        $comments = R::findAll('bcomments', 'requestid = ?  and relatedcommentid = ?', [$requestId, 0]);
        foreach ($comments as $comment) {
            ## get all secondary comments that related to primary one
            $relatedComments = R::findAll('bcomments', 'requestid = ?  and relatedcommentid = ?', [$requestId, $comment->id]);
            foreach ($relatedComments as $relatedComment) {
                ##user who wrote the comment
                $userId = $relatedComment->memberid;
                $user = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$userId]);
                $relatedComment->memberName = $user['name'];
            }
            $comment->childs = $relatedComments;
            ##user who wrote the comment
            $userId = $comment->memberid;
            $user = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$userId]);
            $comment->memberName = $user['name'];
        }

        $members = R::findAll('bsessionmembers', 'sessionid = ? ', [$request->sessionid]);
        foreach ($members as $member) {
            ## members who give opinion
            $userId = $member->memberid;
            $user = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$userId]);
            $member->memberName = $user['name'];
            $userOpinion = R::getRow('SELECT openion FROM bmemberopenion WHERE sessionmemberid = ? and requestid = ? ', [$member->id, $requestId]);
            $member->openion = $userOpinion['openion'];
        }

        $this->smarty->assign('request', $request);
        $this->smarty->assign('comments', $comments);
        $this->smarty->assign('members', $members);
        //call other class with other content
        $this->smarty->display('request_model.html');
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
