<?php
/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */
require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $patientid;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'combinedreport';
        $this->shcontrollname = 'Home';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $this->smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'combinedreport'; //controller name or tab name
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
        $this->patientid = patientdata::patientid();
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        //check login
          autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $allDiagnosis = R::findAll("diagnosis","conditions = 0 ");
        $this->smarty->assign("allDiagnosis",$allDiagnosis);
        
        $allDiagnosisant = R::findAll("diagnosisant","conditions = 0");
        $this->smarty->assign("allDiagnosisant",$allDiagnosisant);
        
        $allOperation = R::findAll("operation","del = 0");
        $this->smarty->assign("allOperation",$allOperation);
        
        $allTermination = R::findAll("phobstericterminate","del = 0");
        $this->smarty->assign("allTermination",$allTermination);
        
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('reports/combined.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }
    
     public function search() 
    {
        //check login
          autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $fAge = filter_input(INPUT_POST, "fage");
        $toage = filter_input(INPUT_POST, "toage");
        $diagnosis = filter_input(INPUT_POST, "diagnosis");
        $diagnosisant = filter_input(INPUT_POST, "diagnosisant");
        $operation = filter_input(INPUT_POST, "operation");
        $termination = filter_input(INPUT_POST, "termination");
        $query = '';
        $diagnosis = json_decode($diagnosis);
        $diagnosisant = json_decode($diagnosisant);
        $valueant="";
        $value="";
        $diagnosisName = "";
        $diagnosisantName = "";
        $operationName = "";
        $terminationName = "";
        if(!empty($diagnosis))
        {
            sort($diagnosis);
            foreach ($diagnosis as $data)
            {
                $value=$value.$data.",";
                $allDiagnosis = R::load("diagnosis",$data);
                $diagnosisName = $diagnosisName.$allDiagnosis->name.",";
            }
            $value= substr($value, 0, -1);
            $diagnosisName= substr($diagnosisName, 0, -1);
            $query.='and gyna.diagnosisid = "'.$value.'" ';
        }
        if(!empty($diagnosisant))
        {
            foreach ($diagnosisant as $data)
            {
                if(strpos($data,"ant") !== false)
                {
                    $data = trim($data, "ant");
                }
                $valueant=$valueant.$data.",";
                $allDiagnosis = R::load("diagnosisant",$data);
                $diagnosisantName = $diagnosisantName.$allDiagnosis->name.",";
            }
            $valueant= substr($valueant, 0, -1);
            $diagnosisantName= substr($diagnosisantName, 0, -1);
            $query.='and antenalvisit.diagnosisid = "'.$valueant.'" ';
        }
        if (!empty($fAge))
        {
            $query.='and wifeage >= '.$fAge.' ';
        }
        if(!empty($toage))
        {
            $query.='and wifeage <= '.$toage.' ';
        }
        if(!empty($operation))
        {
            $operationData = R::load("operation",$operation);
            $operationName = $operationData->name;
            $query.='and operationid = '.$operation.' ';
        }
        if(!empty($termination))
        {
            $termData = R::load("phobstericterminate",$termination);
            $terminationName = $termData->name;
            $query.='and obstermination = '.$termination.' ';
        }
       
        $allData = R::getAll('select wifename,wifeage,husdandname, patients.id as patientid From Patients left join gyna on Patients.Id = gyna.Patientid  left join antenalvisit on Patients.Id = antenalvisit.Patientid left join Operativedetails on Patients.Id = Operativedetails.Patientid left join phobstetric on Patients.Id = phobstetric.patientid Where 1 '.$query.' group by wifename');
        $this->smarty->assign('allData',$allData);
        
        $allPatients = R::findAll('patients','deleted = 0');
        $this->smarty->assign('allPatients',$allPatients);
        
        $countData = (count($allData)/  count($allPatients)*100);
        $this->smarty->assign('percentage',round($countData,2));
        
        $this->smarty->assign('fAge',$fAge);
        $this->smarty->assign('toage',$toage);
        $this->smarty->assign('operation',$operationName);
        $this->smarty->assign('termination',$terminationName);
        $this->smarty->assign('diagnosis',$diagnosisName);
        $this->smarty->assign('diagnosisant',$diagnosisantName);
        
        $this->smarty->display('reports/combinedsearch.html');
    } 
    
    public function showprint() {

        //check login
          autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $fAge = filter_input(INPUT_POST, "fage");
        $toage = filter_input(INPUT_POST, "toage");
        $diagnosis = filter_input(INPUT_POST, "diagnosis");
        $diagnosisant = filter_input(INPUT_POST, "diagnosisant");
        $operation = filter_input(INPUT_POST, "operation");
        $termination = filter_input(INPUT_POST, "termination");
        $query = '';
        $diagnosis = json_decode($diagnosis);
        $diagnosisant = json_decode($diagnosisant);
        $valueant="";
        $value="";
        $diagnosisName = "";
        $diagnosisantName = "";
        $operationName = "";
        $terminationName = "";
        if(!empty($diagnosis))
        {
            sort($diagnosis);
            foreach ($diagnosis as $data)
            {
                $value=$value.$data.",";
                $allDiagnosis = R::load("diagnosis",$data);
                $diagnosisName = $diagnosisName.$allDiagnosis->name.",";
            }
            $value= substr($value, 0, -1);
            $diagnosisName= substr($diagnosisName, 0, -1);
            $query.='and gyna.diagnosisid = "'.$value.'" ';
        }
        if(!empty($diagnosisant))
        {
            foreach ($diagnosisant as $data)
            {
                if(strpos($data,"ant") !== false)
                {
                    $data = trim($data, "ant");
                }
                $valueant=$valueant.$data.",";
                $allDiagnosis = R::load("diagnosisant",$data);
                $diagnosisantName = $diagnosisantName.$allDiagnosis->name.",";
            }
            $valueant= substr($valueant, 0, -1);
            $diagnosisantName= substr($diagnosisantName, 0, -1);
            $query.='and antenalvisit.diagnosisid = "'.$valueant.'" ';
        }
        if (!empty($fAge))
        {
            $query.='and wifeage >= '.$fAge.' ';
        }
        if(!empty($toage))
        {
            $query.='and wifeage <= '.$toage.' ';
        }
        if(!empty($operation))
        {
            $operationData = R::load("operation",$operation);
            $operationName = $operationData->name;
            $query.='and operationid = '.$operation.' ';
        }
        if(!empty($termination))
        {
            $termData = R::load("phobstericterminate",$termination);
            $terminationName = $termData->name;
            $query.='and obstermination = '.$termination.' ';
        }
       
        $allData = R::getAll('select wifename,wifeage,husdandname, patients.id as patientid From Patients left join gyna on Patients.Id = gyna.Patientid  left join antenalvisit on Patients.Id = antenalvisit.Patientid left join Operativedetails on Patients.Id = Operativedetails.Patientid left join phobstetric on Patients.Id = phobstetric.patientid Where 1 '.$query.' group by wifename');
        $this->smarty->assign('allData',$allData);
        
        $allPatients = R::findAll('patients','deleted = 0');
        $this->smarty->assign('allPatients',$allPatients);
        
        $countData = (count($allData)/  count($allPatients)*100);
        $this->smarty->assign('percentage',round($countData,2));
        
        $this->smarty->assign('fAge',$fAge);
        $this->smarty->assign('toage',$toage);
        $this->smarty->assign('operation',$operationName);
        $this->smarty->assign('termination',$terminationName);
        $this->smarty->assign('diagnosis',$diagnosisName);
        $this->smarty->assign('diagnosisant',$diagnosisantName);
        
        
        $this->smarty->display('reports/combinedprint.html');
    }

//   

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
