<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    
    public $time;
    public $today;
    
// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'followupcard';
        $this->shcontrollname = 'FollowUpCard';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'followupcard'; //controller name or tab name
        $active[1] = 'followupcard'; //controller name
        
        $this->active = $active;



        #include upload function
        require_once("../../_library/plugins/classupload/uploadfunctions.php");
        
//here will call all php pages
       require_once("_header.php");
       require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
        
     //find loading time
        $this->time = microtime(true);   
        $this->today = date('Y-m-d');
    }
    
    public function index()
    {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $patientId = filter_input(INPUT_GET, "patientid");

        if (empty($patientId)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientid', $patientId);
        
        $followupcards = R::findAll('followupcard', 'patientid = ? and status = ? and deleted = ?  order by date desc', [$patientId , 1 , 0 ]);
        foreach ($followupcards as $card)
        {
            $doctordata = R::getRow('SELECT user_name FROM awusers WHERE user_id = ? ', [$card->doctorid]);
            $card->doctorName = $doctordata['user_name'];
            
            $card->treatment = '';
            $followupcarddrugs = R::findAll('followupcarddrugs', 'cardid = ?', [$card->id ]);
            foreach ($followupcarddrugs as $fdrug) 
            {
                $drug = R::load('drugs',$fdrug->drugid);
                $card->treatment .= $drug->drugname .',' ;
            }
        }
        
        $this->smarty->assign('followupcards', $followupcards);
        
        $programSetting = R::findOne('programesetting', 'limit 1');
        $this->smarty->assign('programSetting', $programSetting);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
         patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->display('followupcard/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }
    
    public function addit() 
    {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $programSettingData = R::findOne("programesetting");
        $this->smarty->assign("programSettingData",$programSettingData);
        
        $cardId = filter_input(INPUT_GET, "cardid");
        if(!empty($cardId))
        {
            $followupcard = R::load('followupcard', $cardId);
//            $detections = R::load('detections', $visits->detectionid);
            $patient = R::load('patients', $followupcard->patientid);
            $this->smarty->assign('patient', $patient);

            $followupcarddrugs = R::findAll('followupcarddrugs', 'cardid = ?', [$cardId ]);
            foreach ($followupcarddrugs as $fdrug) 
            {
                $drug = R::load('drugs',$fdrug->drugid);
                $fdrug->drugname = $drug->drugname  ;
                $fdrug->currentbalance = $drug->currentbalance  ;
            }

            //$this->smarty->assign('dept', $detections->title);
            $this->smarty->assign('followupcard', $followupcard);
            $this->smarty->assign('followupcarddrugs', $followupcarddrugs);
            
            
            header::headershow($this->smarty, $this->hosturl);
            sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
            patientdata::patientdatashow($this->smarty, $this->hosturl);
            $this->smarty->display('followupcard/showdata.html');
            leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
            footer::footershow($this->smarty, $this->hosturl);
        }
        else
        {
            $patientId = filter_input(INPUT_GET, "patientid");
            $patient = R::load('patients', $patientId);
            $this->smarty->assign('patient', $patient);

             $drugs = R::getAll('SELECT  id , drugname , currentbalance  FROM drugs order by drugname asc');
             $allDrugcats = R::getAll('SELECT distinct  drugcat   FROM drugs order by drugcat asc');
             $allDrugTypes = R::getAll('SELECT distinct  drugtype  FROM drugs order by drugtype asc');
             $allDrugDoses = R::getAll('SELECT distinct  drugdos   FROM drugs order by drugdos asc');

             $this->smarty->assign('drugs', $drugs);
             $this->smarty->assign('allDrugcats', $allDrugcats);
             $this->smarty->assign('allDrugTypes', $allDrugTypes);
             $this->smarty->assign('allDrugDoses', $allDrugDoses);

             //select table siteinfo data to order by id
             $followupcard = R::findOne('followupcard', 'patientid = ? and status = ?  order by date desc', [$patientId , 0 ]);
             if (count($followupcard) > 0)
             {


             }
             else 
             {
                 $followupcard = R::dispense('followupcard');
                 R::freeze('followupcard');

                 $visits = R::findOne('visits', 'patientid = ? and deleted = ?  order by visitdate desc', [$patientId , 0 ]);

                 $followupcard->enterdate = $visits->visitdate;
                 $followupcard->exitdate = date('Y-m-d');
                 $followupcard->date = date('Y-m-d');
                 $followupcard->patientid = $patientId;
                 $followupcard->doctorid = $_SESSION['user_id'];
                 $followupcard->diagnosis = '';
                 $followupcard->status = 0;
                 $followupcard->deptid = $visits->detectionid;
                 try 
                 {
                     $followupcard->id  = R::store($followupcard);     
                 } 
                 catch (Exception $e) 
                 {
                     header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
                 }
             }

             $followupcard->enterdate = date("d-m-Y", strtotime($followupcard->enterdate));;
             $followupcard->exitdate = date("d-m-Y", strtotime($followupcard->exitdate));

             $this->smarty->assign('followupcard', $followupcard);

             $followupcarddrugs = R::findAll('followupcarddrugs','cardid = ?',[$followupcard->id]);
             $this->smarty->assign('followupcarddrugs', $followupcarddrugs);
             $this->smarty->assign('followupcarddrugsCount', count($followupcarddrugs));
             
             header::headershow($this->smarty, $this->hosturl);
            sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
            patientdata::patientdatashow($this->smarty, $this->hosturl);
            $this->smarty->display('followupcard/add.html');
            leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
            footer::footershow($this->smarty, $this->hosturl);
        }
        

            
        
    }
    
     public function drawRow() 
    {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $itr = filter_input(INPUT_POST, "itr");
        $this->smarty->assign('itr', $itr);
        
        $programSettingData = R::findOne("programesetting");
        $this->smarty->assign("programSettingData",$programSettingData);
        
        $drugs = R::getAll('SELECT  id , drugname , currentbalance  FROM drugs order by drugname asc');
        $allDrugcats = R::getAll('SELECT distinct  drugcat   FROM drugs order by drugcat asc');
        $allDrugTypes = R::getAll('SELECT distinct  drugtype  FROM drugs order by drugtype asc');
        $allDrugDoses = R::getAll('SELECT distinct  drugdos   FROM drugs order by drugdos asc');

        $this->smarty->assign('drugs', $drugs);
        $this->smarty->assign('allDrugcats', $allDrugcats);
        $this->smarty->assign('allDrugTypes', $allDrugTypes);
        $this->smarty->assign('allDrugDoses', $allDrugDoses);
        
        $this->smarty->display('followupcard/drawRow.html');
    }
    
    
    public function update() 
    {
        ## check login
        autho::checkautho($this->hosturl);
        ## check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
        $id = filter_input(INPUT_POST, "id");
        $tablename = filter_input(INPUT_POST, "tableName");
        $colname = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");
        $dated = filter_input(INPUT_POST, "dated");

        
        if($dated == 1)
        {
            $value = date("Y-m-d", strtotime($value));
        }
        
        
        $obj = R::load($tablename, $id);
        $obj->$colname = $value;
        R::store($obj);
        if($tablename = 'followupcard' && $colname = 'deleted' && $value = 1)
        {
            echo 1 ;
        }
    }
    
    
    
    public function printit() 
    {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        
       $itr = filter_input(INPUT_POST, "drugItr");
       $print = filter_input(INPUT_POST, "cardPrint");
       $cardId = filter_input(INPUT_POST, "followupcardid");
       $patientId = filter_input(INPUT_POST, "patientId");
       if($print == 'yesOnly')
       {
           $followupcard = R::load('followupcard', $cardId);
            $detections = R::load('detections', $followupcard->deptid);
            $patient = R::load('patients', $followupcard->patientid);
            $this->smarty->assign('patient', $patient);

            $followupcarddrugs = R::findAll('followupcarddrugs', 'cardid = ?', [$cardId ]);
            foreach ($followupcarddrugs as $fdrug) 
            {
                $drug = R::load('drugs',$fdrug->drugid);
                $fdrug->drugname = $drug->drugname  ;
            }

            $this->smarty->assign('dept', $detections->title);
            $this->smarty->assign('followupcard', $followupcard);
            $this->smarty->assign('followupcarddrugs', $followupcarddrugs);
            $this->smarty->display('followupcard/print.html');
       }
       else
       {
                $followupcard= R::load('followupcard', $cardId);
                if($followupcard->status == 0)
                {
                        $followupcard->status = 1 ;
                         
                        ## add pres to pharmacy to allow caching it 
                        $recepittmp = R::dispense('recepittmp');
                        $recepittmp->doctor_id = $_SESSION['user_id'];
                        $recepittmp->patient_id = $patientId ;
                        $recepittmp->rect_date = date("Y-m-d"); 
                        $recepittmp->drugstablename = 'followupcarddrugs' ;
                        $recepittmp->status = 0 ;

                        $recepittmpId = R::store($recepittmp);
            
            
                         for($i=1 ; $i <= $itr ;$i++)
                         {
                             $dname = filter_input(INPUT_POST, "dname".$i);
                             if($dname !='')
                             {
                                 $dtype = filter_input(INPUT_POST, "dtype".$i);
                                 $ddos = filter_input(INPUT_POST, "ddos".$i);

                                 $followupcarddrugs = R::dispense('followupcarddrugs');
                                 $followupcarddrugs->cardid =  $cardId;
                                 $followupcarddrugs->drugid =  $dname;
                                 $followupcarddrugs->drugtype =  $dtype;
                                 $followupcarddrugs->drugdos =  $ddos;
                                 $followupcarddrugs->recepittmpid = $recepittmpId;

                                  R::store($followupcarddrugs);
                                  
                                  ## add to pharmace to allow caching drugs
                                if($dname != 0)
                                {
                                    $receiptdrugs = R::dispense('receiptdrugs');
                                    $receiptdrugs->drugs_id =  $dname;
                                    $receiptdrugs->amount =  1;
                                    $receiptdrugs->receipt_id = $recepittmpId;

                                    R::store($receiptdrugs);
                                }                                
                                 
                             }
                         }

                          //get all vars

                              try 
                              {
                                  $id = R::store($followupcard);
                                  if($print == 'yes')
                                  {
                                      $visits = R::findOne('visits', 'patientid = ? and deleted = ?  order by visitdate desc', [$patientId , 0 ]);
                                      $detections = R::load('detections', $visits->detectionid);
                                      $patient = R::load('patients', $patientId);
                                      $this->smarty->assign('patient', $patient);

                                      $followupcarddrugs = R::findAll('followupcarddrugs', 'cardid = ?', [$cardId ]);
                                      foreach ($followupcarddrugs as $fdrug) 
                                      {
                                          $drug = R::load('drugs',$fdrug->drugid);
                                          $fdrug->drugname = $drug->drugname  ;
                                      }

                                      $this->smarty->assign('dept', $detections->title);
                                      $this->smarty->assign('followupcard', $followupcard);
                                      $this->smarty->assign('followupcarddrugs', $followupcarddrugs);
                                      $this->smarty->display('followupcard/print.html');
                                  }

                              } 
                              catch (Exception $e) 
                              {
                                  //header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
                              }
                }

                 else 
                 {
                     header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?patientid='.$patientId);
                 }
       }
       

        
    }
    
     // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
    
    
