<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'infertilitysheet';
        $this->shcontrollname = 'Infertilitysheet';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        require_once("../../_library/plugins/classupload/uploadfunctions.php");
        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'Infertilitysheet'; //controller name or tab name
        $active[1] = 'Infertilitysheet'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'menuadd';
                break;
            case 'show':$active[2] = 'menushow';
                break;
            default :$active[2] = 'menushow';
                break;
        }
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        $patientid = filter_input(INPUT_GET, "patientid");


        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }

        $patient = R::load('patients', $patientid);
        $this->smarty->assign('patientid', $patientid);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        #################################################################### Heba : ## Drugs Data   ##############################################################################
        ## get id and distinct drugname
        $this->getprescription($patientid, date("Y-m-d"), 0);
        $this->smarty->assign('presDate', date("Y/m/d"));
        #################################################################### Heba : ## Investigation data  ##############################################################################
        $questions1 = R::findall('investcats', 'deleted = ? and displayorder in (1 , 2) order by displayorder ', [0]);
        foreach ($questions1 as $cat) {
            $invests = R::findall('invests', 'investcatid = ? and deleted = ?', [$cat->id, 0]);
            $cat->invests = $invests;
        }

        $questions2 = R::findall('investcats', 'deleted = ? and displayorder = 3 order by displayorder ', [0]);
        foreach ($questions2 as $cat) {
            $invests = R::findall('invests', 'investcatid = ? and deleted = ?', [$cat->id, 0]);
            $cat->invests = $invests;
        }

        $questions3 = R::findall('investcats', 'deleted = ? and displayorder in (4 , 5) order by displayorder ', [0]);
        foreach ($questions3 as $cat) {
            $invests = R::findall('invests', 'investcatid = ? and deleted = ?', [$cat->id, 0]);
            $cat->invests = $invests;
        }

        $questions4 = R::findall('investcats', 'deleted = ? and displayorder  between 6 and  11 order by displayorder ', [0]);
        foreach ($questions4 as $cat) {
            $invests = R::findall('invests', 'investcatid = ? and deleted = ?', [$cat->id, 0]);
            $cat->invests = $invests;
        }

        $questions5 = R::findall('investcats', 'deleted = ? and displayorder > 11 order by displayorder ', [0]);
        foreach ($questions5 as $cat) {
            $invests = R::findall('invests', 'investcatid = ? and deleted = ?', [$cat->id, 0]);
            $cat->invests = $invests;
        }

        $others = R::findall('investcats', 'deleted = ? and displayorder = ?  order by displayorder ', [0, 0]);
        foreach ($others as $cat) {
            $invests = R::findall('invests', 'investcatid = ? and deleted = ?', [$cat->id, 0]);
            $cat->invests = $invests;
        }


        $favorites = R::findall('invests', 'deleted = ? and  favorite= ?', [0, 1]);

        //$this->smarty->assign('allInvCats',$questions);
        $this->smarty->assign('favorites', $favorites);
        $this->smarty->assign('group1', $questions1);
        $this->smarty->assign('group2', $questions2);
        $this->smarty->assign('group3', $questions3);
        $this->smarty->assign('group4', $questions4);
        $this->smarty->assign('group5', $questions5);
        $this->smarty->assign('others', $others);

        //Save entering gyna
        $lastVisitData = R::findOne('lastvisit', 'patientid = ? order by id desc ', [$patientid]);

        $lastVisit = R::dispense('lastvisit');
        $lastVisit->patientid = $patientid;
        $lastVisit->control = $this->controllname;
        if ($lastVisitData->patientid == $patientid) {
            $lastVisit->id = $lastVisitData->id;
        }
        R::store($lastVisit);


        $this->smarty->assign('patient', $patient);

        $infertilitysheet = R::findOne('infertilitysheet', 'patientid = ?', [$patientid]);

        if ($infertilitysheet) {
            $vowels = array("--", "**");
            $infertilitysheet->importantnotes = str_replace($vowels, '<br>', $infertilitysheet->importantnote);
            $id = $infertilitysheet->id;
        } else {
            $infertilitysheet = R::dispense('infertilitysheet');
            $infertilitysheet->patientid = $patientid;
            $id = R::store($infertilitysheet);
            $infertilitysheet->id = $id;
        }
        $this->smarty->assign('id', $id);
        $this->smarty->assign('infertilitysheet', $infertilitysheet);
        $this->loadOne($id);

        $gynasheet = R::findOne('gynasheet', 'patientid = ?', [$patientid]);

        if ($gynasheet) {
            $gynasheetid = $gynasheet->id;
        } else {
            $gynasheet = R::dispense('gynasheet');
            $gynasheet->patientid = $patientid;
            $gynasheetid = R::store($gynasheet);
            $gynasheet->id = $gynasheetid;
        }

        $this->smarty->assign('gynasheetid', $gynasheetid);
        $this->smarty->assign('gynasheet', $gynasheet);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->display('infertilitysheet/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    function loadOne($id) {
        $semen = R::findAll('semeninfertility', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('semen', $semen);

        $semen2 = R::findAll('semen2', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('semen2', $semen2);

        $hormonalprofile = R::findAll('hormonalprofile', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('hormonalprofile', $hormonalprofile);

        $awifep = R::findAll('awifep', 'infertilitysheetid = ?', [$id]);
        foreach ($awifep as $awife) {
            $date2 = new DateTime($awife->date);
            $today1 = new DateTime(date('Y-m-d'));
            $interval = $today1->diff($date2);
            $awife->wifeage = $interval->y . 'Y ' . $interval->m . 'M ';
        }
        $this->smarty->assign('awifep', $awifep);

        $wifeepc = R::findAll('wifeepc', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('wifeepc', $wifeepc);

        $hormonalprofile2 = R::findAll('hormonalprofile2', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('hormonalprofile2', $hormonalprofile2);

        $tvs = R::findAll('tvs', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('tvs', $tvs);

        $dtvs = R::findAll('dtvs', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('dtvs', $dtvs);

        $sis = R::findAll('sis', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('sis', $sis);

        $hsg = R::findAll('hsginfertility', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('hsg', $hsg);

        $hysteroscopy = R::findAll('hysteroscopyinfertility', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('hysteroscopy', $hysteroscopy);

        $laparoscopy = R::findAll('laparoscopyinfertility', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('laparoscopy', $laparoscopy);

        $infertilityother = R::findAll('infertilityother', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('infertilityother', $infertilityother);

        $icsi = R::findAll('icsi', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('icsi', $icsi);

        $folliculom = R::findAll('folliculom', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('folliculom', $folliculom);

        $operations = R::findAll('operations', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('operations', $operations);

        $newvisit = R::findAll('newvisit', 'infertilitysheetid = ?', [$id]);
        $this->smarty->assign('newvisit', $newvisit);
    }

    private function getprescription($patientId, $date, $preFor) {
        $PatientPresByDate = R::findall('infertilitysheetdrugs', 'deleted = ? and patientid = ? and date = ? and forhusband = ?', [0, $patientId, $date, $preFor]);


        $drugs = R::getAll('SELECT  id , drugname ,currentbalance  FROM drugs order by drugname asc');
        $allDrugcats = R::getAll('SELECT distinct  drugcat   FROM drugs order by drugcat asc');
        $allDrugTypes = R::getAll('SELECT distinct  drugtype  FROM drugs order by drugtype asc');
        $allDrugDoses = R::getAll('SELECT distinct  drugdos   FROM drugs order by drugdos asc');

        foreach ($PatientPresByDate as $pre) {
            $dd = R::load('drugs', $pre->drugid);
            $pre->drugcat = $dd->drugcat;
        }
        $this->smarty->assign('drugs', $drugs);
        $this->smarty->assign('allDrugcats', $allDrugcats);
        $this->smarty->assign('allDrugTypes', $allDrugTypes);
        $this->smarty->assign('allDrugDoses', $allDrugDoses);
        $this->smarty->assign('PatientPresByDate', $PatientPresByDate);
        $this->smarty->assign('preItr', count($PatientPresByDate));
    }

//    public function Add() {
//        $table = filter_input(INPUT_POST, 'table');
//        $id = filter_input(INPUT_POST, 'id');
//        $name = filter_input(INPUT_POST, 'name');
//        $value = filter_input(INPUT_POST, 'value');
//        try {
//            R::exec("update $table set $name = '" . $value . "' where id = $id");
//            echo '1';
//        } catch (Exception $e) {
//            echo '0';
//        }
//    }

    public function Add() {
        $tableName = filter_input(INPUT_POST, 'table');
        $id = filter_input(INPUT_POST, 'id');
        $colName = filter_input(INPUT_POST, 'name');
        $value = filter_input(INPUT_POST, 'value');
        try {
            $obj = R::load($tableName, $id);
            $obj->$colName = $value;
            R::store($obj);
            echo '1';
        } catch (Exception $e) {
            echo '0';
        }
    }

    public function obstetric() {

        $id = filter_input(INPUT_POST, 'id');
        $tableadd = R::load('infertilitysheet', $id);
        $FT = R::findOne('wifetypeofd', 'title = "FT"');
        $PT = R::findOne('wifetypeofd', 'title = "PT"');
        $wifepft = R::count('awifep', 'wifetypeofd = ? and infertilitysheetid = ?', [$FT->id, $id]);
        $wifeppt = R::count('awifep', 'wifetypeofd = ? and infertilitysheetid = ?', [$PT->id, $id]);
        $wifeepcepc = R::count('wifeepc', 'infertilitysheetid = ? and wifeepctype > 0 ', [$id]);
        $wifel = R::count('awifep', 'infertilitysheetid = ? and wifel = 1', [$id]);
        $ancsheet = R::findOne('ancsheet', 'patientid = ? and endpreg = 0', [$tableadd->patientid]);
        if ($ancsheet->sheetlmp) {
            $tableadd->obstg = ($wifepft + $wifeppt + $wifeepcepc + 1);
        } else {
            $tableadd->obstg = ($wifepft + $wifeppt + $wifeepcepc);
        }
        $tableadd->obstp = ($wifepft + $wifeppt);
        $tableadd->obstft = $wifepft;
        $tableadd->obstpt = $wifeppt;
        $tableadd->obstepc = $wifeepcepc;
        $tableadd->obstliving = $wifel;
        R::store($tableadd);

        $data = $tableadd->obstg;
        $data .= ',' . ($wifepft + $wifeppt);
        $data .= ',' . $wifepft;
        $data .= ',' . $wifeppt;
        $data .= ',' . $wifeepcepc;
        $data .= ',' . $wifel;
        echo $data;
    }

    public function append() {


        $tablename = filter_input(INPUT_POST, 'tablename');
        $tablep = filter_input(INPUT_POST, 'tablep');
        $id = filter_input(INPUT_POST, 'id');
        $tablenameappend = R::dispense($tablename);
        $tablenameappend->$tablep = $id;
        $tablenameappend->date = date("Y/m/d");
        $tablenameappendid = R::store($tablenameappend);

        $this->smarty->assign('today', date("Y/m/d"));
        $this->smarty->assign('tablename', $tablename);
        $this->smarty->assign('id', $tablenameappendid);
        $this->smarty->display('infertilitysheet/append.html');
    }

    public function folliculom() {
        $id = filter_input(INPUT_POST, 'id');
        $value = filter_input(INPUT_POST, 'value');
        $infertilitysheetid = filter_input(INPUT_POST, 'infertilitysheetid');
        $folliculom = R::getRow("SELECT * FROM `folliculom` WHERE folliculom.lmp IS NOT NULL and id <= $id 
            and infertilitysheetid = $infertilitysheetid order by id DESC");
        $dt = $folliculom['lmp'];
        echo date("Y/m/d", strtotime("$dt +$value day"));
    }

    public function getselectajax() {
        //check login
        autho::checkautho($this->hosturl);

        $newterm = filter_input(INPUT_POST, 'newterm');
        $celtable = filter_input(INPUT_POST, 'celtable');

        $tableadd = R::dispense($celtable);
        $tableadd->title = $newterm;
        $tableadd->del = null;
        $inserted = R::store($tableadd);
        echo $inserted;
    }

    public function getselect() {
        //check login
        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, 'id');
        $tablep = filter_input(INPUT_POST, 'tablep');
        $celtable = filter_input(INPUT_POST, 'celtable');
        $name = filter_input(INPUT_POST, 'name');
        $selid = filter_input(INPUT_POST, 'selid');
        $kind = filter_input(INPUT_POST, 'kind');
        $tablep = R::load($tablep, $selid);
        $celtable = R::findAll($celtable, 'del is null');
        $this->smarty->assign('tablep', $tablep);
        $this->smarty->assign('arrays', explode(',', $tablep->$name));
        $this->smarty->assign('celtable', $celtable);
        $this->smarty->assign('name', $name);
        $this->smarty->assign('id', $id);
        $this->smarty->assign('kind', $kind);
        $this->smarty->assign('selid', $selid);
        $this->smarty->display('infertilitysheet/select.html');
    }

    public function getdataselect() {
        //check login
        autho::checkautho($this->hosturl);

        $celtable = filter_input(INPUT_POST, 'celtable');
        $allceltable = R::findAll($celtable, 'del is null');
        $count = R::count($celtable, 'del is null');
        if ($count < 1) {
            echo "0";
            exit();
        }
        $this->smarty->assign('celtable', $celtable);
        $this->smarty->assign('allceltable', $allceltable);
        $this->smarty->display('infertilitysheet/delselect.html');
    }

    public function deldataselect() {
        //check login
        autho::checkautho($this->hosturl);

        $table = filter_input(INPUT_POST, 'table');
        $id = filter_input(INPUT_POST, 'id');
        $celtables = R::load($table, $id);
        $celtables->del = 1;
        try {
            $inserted = R::store($celtables);
            echo $inserted;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function addnewselect() {
        //check login
        autho::checkautho($this->hosturl);

        $table = filter_input(INPUT_POST, 'table');
        $celtables = R::dispense($table);
        $celtables->title = $newterm;
        $inserted = R::store($celtables);
        $out = '<tr id="remove_' . $inserted . '">
                  <td style="width: 100%">
                    <input class="form-control "  type="text"  name="title" data-id="' . $inserted . '"  data-table="' . $table . '" value="" >
                  </td>
                  <td>
                     <a href="#" style="width: 100%" class="btn red fleft deleteselect" data-table="' . $table . '" data-id="' . $inserted . '">
                     <i class="fa fa-times" ></i>
                     </a>
                  </td>
               </tr>';
        echo $out;
    }

    public function deleterow() {
        //check login
        autho::checkautho($this->hosturl);

        $table = filter_input(INPUT_POST, 'tablep');
        $id = filter_input(INPUT_POST, 'id');
        $celtables = R::load($table, $id);
        try {
            R::trash($celtables);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function update() { //check login
        autho::checkautho($this->hosturl);
//        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $tablename = filter_input(INPUT_POST, "tableName");
        $colname = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");
        $vdateFlag = filter_input(INPUT_POST, "vdateFlag");


        if ($tablename == 'infertilitysheetdrugs') {
            $this->updatedrugs($id, $tablename, $colname, $value);
        } else {
            $gyna_obj = R::load($tablename, $id);
            if ($vdateFlag == true) {
                $value = date("Y/m/d", strtotime($value));
            }

            $dated = filter_input(INPUT_POST, "dated");

            if ($dated == 1) {
                $value = date("Y/m/d", strtotime($value));
            }

            $gyna_obj->$colname = $value;
            R::store($gyna_obj);
        }
    }

    private function updatedrugs($id, $tablename, $colname, $value) {
        $obj = R::load($tablename, $id);
        if ($colname == 'drugid') {
            if ($value != '') {
                $drug = R::load("drugs", $value);
                $obj->drugname = $drug->drugname;
            }
        }

        $obj->$colname = $value;
        try {
            R::store($obj);
        } catch (Exception $e) {
            //header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    ##########################################

    public function showprescription() {       ## show prescriptions of patient
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $patientId = filter_input(INPUT_POST, "patientId");
        $type = filter_input(INPUT_POST, "type");  ## show or edit
        $preFor = filter_input(INPUT_POST, "preFor");
        ## show all prescription of patient
        if ($type == "show") {
            $dates = R::getAll('SELECT DISTINCT date  FROM infertilitysheetdrugs WHERE deleted = ? and patientid = ?  order by date desc', [0, $patientId]);
            $countHusband = array();
            $countWife = array();
            $i = 0;
            foreach ($dates as $date) {
                ## all prescription of certain patient


                $PatientPresByDateWife = R::findall('infertilitysheetdrugs', 'deleted = ? and patientid = ? and date = ? and forhusband = ? ', [0, $patientId, $date['date'], 0]);
                $PatientPresByDateHusband = R::findall('infertilitysheetdrugs', 'deleted = ? and patientid = ? and date = ? and forhusband = ?', [0, $patientId, $date['date'], 1]);


                $j = 0;

                foreach ($PatientPresByDateWife as $pres) {
                    $dd = R::load('drugs', $pres->drugid);
                    if ($j == 0) {
                        $dates[$i]["drugdos"] = "";
                        $dates[$i]["drugdos"] = $dd->drugname;
                    } else {
                        $dates[$i]["drugdos"] = $dates[$i]["drugdos"] . ' , ' . $dd->drugname;
                    }

                    $j++;
                }

                $j = 0;

                foreach ($PatientPresByDateHusband as $pres) {
                    $dd = R::load('drugs', $pres->drugid);
                    if ($j == 0) {
                        $dates[$i]["drugtype"] = "";
                        $dates[$i]["drugtype"] = $dd->drugname;
                    } else {
                        $dates[$i]["drugtype"] = $dates[$i]["drugtype"] . ' , ' . $dd->drugname;
                    }

                    $j++;
                }

                $dates[$i]['date'] = date("Y/m/d", strtotime($dates[$i]['date']));
                $countHusband[$dates[$i]['date']] = count($PatientPresByDateHusband);
                $countWife[$dates[$i]['date']] = count($PatientPresByDateWife);


                $i++;
            }

            $this->smarty->assign('countHusband', $countHusband);
            $this->smarty->assign('countWife', $countWife);
            $this->smarty->assign('dates', $dates);

            $this->smarty->display('infertilitysheet/showPrescriptions.html');
        }

        ## show  prescription of patient with determined date to edit it
        else if ($type == "edit") {
            $date = filter_input(INPUT_POST, "preDate");
            $date = date("Y-m-d", strtotime($date));
            $this->getprescription($patientId, $date, $preFor);
            $this->smarty->assign('type', "drugedit");
            $this->smarty->display('infertilitysheet/newrowdrugedit.html');
        }
    }

    public function printpre() {       ## show prescriptions of patient
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_POST, "patientId");
        $date = filter_input(INPUT_POST, "date");
        $printDate = filter_input(INPUT_POST, "printDate");
        $preFor = filter_input(INPUT_POST, "preFor");
        $patient = R::load('patients', $patientId);
        $wifetypes = R::load('wifetypes', $patient->wiftypeid);
        $husbandtypes = R::load('husbandtypes', $patient->husbandtypeid);



        $date = date("Y/m/d", strtotime($date));
        $this->smarty->assign('date', $date);
        if (isset($printDate) && !empty($printDate)) {
            $printDate = date("Y/m/d", strtotime($printDate));
            $this->smarty->assign('printDate', $printDate);
        } else {
            $this->smarty->assign('printDate', $date);
        }



        ## all prescription of certain patient
        $PatientPresByDate = R::findall('infertilitysheetdrugs', 'deleted = ? and patientid = ? and date = ? and forhusband = ? ', [0, $patientId, $date, $preFor]);
        if ($preFor == 1) {
            $this->smarty->assign('name', $patient->husdandname);
            $this->smarty->assign('title', $husbandtypes->title);
        } elseif ($preFor == 0) {
            $this->smarty->assign('name', $patient->wifename);
            $this->smarty->assign('title', $wifetypes->title);
        }


        foreach ($PatientPresByDate as $pre) {
            $dd = R::load('drugs', $pre->drugid);
            $pre->drugname = $dd->drugname;
        }

        $this->smarty->assign('drugs', $PatientPresByDate);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $this->smarty->assign('statusNo', $patient->statusno);
        $this->smarty->display('gyna/print.html');
    }

    public function addprescription() {       ## delete drug
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");

        try {
            $myObject = R::load('infertilitysheetdrugs', $id);
            $myObject->deleted = 1;
            R::store($myObject);
            echo 1;
            //header('Location:' . $this->hosturl . '/controllers/' . $this->controllname.'.php?ac=index' );
        } catch (Exception $e) {
            //header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    #############################################

    public function addinvestigation() {       ## add prescription to patient
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_POST, 'patientId');
        $investsList = $_POST['invCheck'];
        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $invDate = filter_input(INPUT_POST, 'invDate');
        $printDate = filter_input(INPUT_POST, 'printInvDate');

        $forHusband = filter_input(INPUT_POST, 'forHusband');
        if ($forHusband != 1) {
            $forHusband = 0;
        }

        $patient = R::load('patients', $patientId);
        $wifetypes = R::load('wifetypes', $patient->wiftypeid);
        $husbandtypes = R::load('husbandtypes', $patient->husbandtypeid);

        $this->smarty->assign('date', date("Y/m/d", strtotime($printDate)));

        if (!empty($investsList)) {
            $invests = array();
            foreach ($investsList as $check) {
                $gynaInvest = R::dispense('infertilitysheetinvest');
                $gynaInvest->patientid = $patientId;
                $gynaInvest->date = date("Y-m-d", strtotime($invDate));
                $gynaInvest->investid = $check;
                $gynaInvest->doctorid = $_SESSION['user_id'];
                $gynaInvest->deleted = 0;
                $gynaInvest->forhusband = $forHusband;

                array_push($invests, $gynaInvest);
            }

            try {
                R::storeAll($invests);
                foreach ($invests as $invest) {
                    $investm = R::load('invests', $invest->investid);
                    $invest->name = $investm->name;
                }
                $this->smarty->assign('investigations', $invests);
                if ($forHusband == 1) {
                    $this->smarty->assign('name', $patient->husdandname);
                    $this->smarty->assign('title', $husbandtypes->title);
                } else {
                    $this->smarty->assign('name', $patient->wifename);
                    $this->smarty->assign('title', $wifetypes->title);
                }
                $this->smarty->assign('statusNo', $patient->statusno);
                $this->smarty->display('gyna/printinv.html');
            } catch (Exception $e) {
                header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
            }
        }
    }

    public function showInvs() {       ## show prescriptions of patient
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_POST, "patientId");

        ## show all investigations of patient
        $dates = R::getAll('SELECT DISTINCT date  FROM infertilitysheetinvest WHERE deleted = ? and patientid = ?  order by date desc ', [0, $patientId]);
        $countHusband = array();
        $countWife = array();
        $i = 0;
        foreach ($dates as $date) {
            ## all invs of certain patient
            $PatientInvByDateHusband = R::findall('infertilitysheetinvest', 'deleted = ? and patientid = ? and date = ? and forhusband = ? ', [0, $patientId, $date['date'], 1]);
            $PatientInvByDateWife = R::findall('infertilitysheetinvest', 'deleted = ? and patientid = ? and date = ? and forhusband = ? ', [0, $patientId, $date['date'], 0]);




            foreach ($PatientInvByDateHusband as $in) {
                $invest = R::load('invests', $in->investid);
                $in->invname = $invest->name;
            }

            foreach ($PatientInvByDateWife as $in) {
                $invest = R::load('invests', $in->investid);
                $in->invname = $invest->name;
            }


            $dates[$i]['investsh'] = $PatientInvByDateHusband;
            $dates[$i]['investsw'] = $PatientInvByDateWife;
            $dates[$i]['date'] = date("Y/m/d", strtotime($dates[$i]['date']));

            $countHusband[$dates[$i]['date']] = count($PatientInvByDateHusband);
            $countWife[$dates[$i]['date']] = count($PatientInvByDateWife);


            $i++;
        }


        $this->smarty->assign('countHusband', $countHusband);
        $this->smarty->assign('countWife', $countWife);
        $this->smarty->assign('dates', $dates);
        $this->smarty->display('infertilitysheet/showInvestigation.html');
    }

    public function printinv() {       ## show prescriptions of patient
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_POST, "patientId");
        $date = filter_input(INPUT_POST, "date");
        $dataFor = filter_input(INPUT_POST, "dataFor");

        $patient = R::load('patients', $patientId);
        $wifetypes = R::load('wifetypes', $patient->wiftypeid);
        $husbandtypes = R::load('husbandtypes', $patient->husbandtypeid);


        $date = date("Y/m/d", strtotime($date));
        $this->smarty->assign('date', $date);



        if ($dataFor == 'wife') {
            $this->smarty->assign('name', $patient->wifename);
            $this->smarty->assign('title', $wifetypes->title);
        } elseif ($dataFor == 'husband') {
            $this->smarty->assign('name', $patient->husdandname);
            $this->smarty->assign('title', $husbandtypes->title);
        }


        ## all prescription of certain patient
        if ($dataFor == 'wife') {
            $PatientInvByDate = R::findall('infertilitysheetinvest', 'deleted = ? and patientid = ? and date = ? and forhusband = ? ', [0, $patientId, $date, 0]);
        } elseif ($dataFor == 'husband') {
            $PatientInvByDate = R::findall('infertilitysheetinvest', 'deleted = ? and patientid = ? and date = ?  and forhusband = ?', [0, $patientId, $date, 1]);
        }



        foreach ($PatientInvByDate as $invest) {
            $investm = R::load('invests', $invest->investid);
            $invest->name = $investm->name;
        }
        $this->smarty->assign('investigations', $PatientInvByDate);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $this->smarty->assign('statusNo', $patient->statusno);
        $this->smarty->display('gyna/printinv.html');
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
