<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'Ivfsheet';
        $this->shcontrollname = 'Menu control';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        require_once("../../_library/plugins/classupload/uploadfunctions.php");
        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'managment'; //controller name or tab name
        $active[1] = 'Ivfsheet'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'menuadd';
                break;
            case 'show':$active[2] = 'menushow';
                break;
            default :$active[2] = 'menushow';
                break;
        }
        $this->active = $active;


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    //here the frist page and
    //the frist action in this class
    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        $patientid = filter_input(INPUT_GET, "patientid");

        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $patient = R::load('patients', $patientid);
        $this->smarty->assign('patient', $patient);

        // ancsheet
        $ivfsheet = R::findOne('ivfsheet', 'patientid = ? and endpreg = 0', [$patientid]);

        if ($ivfsheet) {
            $id = $ivfsheet->id;
            $this->smarty->assign('id', $id);
            $this->smarty->assign('ivfsheet', $ivfsheet);
            $investigations = R::findAll('investigations', 'ancsheetid = ?', [$id]);
            $this->smarty->assign('investigations', $investigations);
            $ovst = R::findAll('ovst', 'ivfsheetid = ?', [$id]);
            $this->smarty->assign('ovst', $ovst);
            $eprep = R::findAll('eprep', 'ivfsheetid = ?', [$id]);
            $this->smarty->assign('eprep', $eprep);
        } else {
            $ivfsheet = R::dispense('ivfsheet');
            $ivfsheet->patientid = $patientid;
            $ivfsheet->endpreg = 0;
            $id = R::store($ivfsheet);
            $this->smarty->assign('id', $id);
        }
        $infertilitysheet = R::findOne('infertilitysheet', 'patientid = ?', [$patientid]);
        if ($infertilitysheet) {
            $infertilitysheetid = $infertilitysheet->id;
            $this->smarty->assign('infertilitysheetid', $infertilitysheetid);
            $this->smarty->assign('infertilitysheet', $infertilitysheet);
            $awifep = R::findAll('awifep', 'infertilitysheetid = ?', [$infertilitysheetid]);
            $this->smarty->assign('awifep', $awifep);
            $wifeepc = R::findAll('wifeepc', 'infertilitysheetid = ?', [$infertilitysheetid]);
            $this->smarty->assign('wifeepc', $wifeepc);
        } else {
            $infertilitysheet = R::dispense('infertilitysheet');
            $infertilitysheet->patientid = $patientid;
            $infertilitysheetid = R::store($infertilitysheet);
            $this->smarty->assign('infertilitysheetid', $infertilitysheetid);
        }


        $gynasheet = R::findOne('gynasheet', 'patientid = ?', [$patientid]);

        if ($gynasheet) {
            $gynasheetid = $gynasheet->id;
            $this->smarty->assign('gynasheetid', $gynasheetid);
            $this->smarty->assign('gynasheet', $gynasheet);
        } else {
            $gynasheet = R::dispense('gynasheet');
            $gynasheet->patientid = $patientid;
            $gynasheetid = R::store($gynasheet);
            $this->smarty->assign('gynasheetid', $gynasheetid);
        }


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->display('Ivfsheet/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function Add() {
        $tableName = filter_input(INPUT_POST, 'table');
        $id = filter_input(INPUT_POST, 'id');
        $colName = filter_input(INPUT_POST, 'name');
        $value = filter_input(INPUT_POST, 'value');

        try {
            $obj = R::load($tableName, $id);
            $obj->$colName = $value;
            R::store($obj);
        } catch (Exception $e) {
            
        }
    }

    // public function Add() {
    //     $table = filter_input(INPUT_POST, 'table');
    //     $id = filter_input(INPUT_POST, 'id');
    //     $name = filter_input(INPUT_POST, 'name');
    //     $value = filter_input(INPUT_POST, 'value');
    //     $tableadd = R::load($table, $id);
    //     $tableadd->$name = $value;
    //     R::store($tableadd);
    // }




    public function endpreg() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize

        $patientid = filter_input(INPUT_POST, "patientid");
        $kind = filter_input(INPUT_POST, "kind");
        $ivfsheet = R::findOne('ivfsheet', 'patientid = ? and endpreg = 0 ', [$patientid]);
        $ivfsheetanprotocol = R::findOne('icsiprotocol', 'id = ?', [$ivfsheet->anprotocol]);
        $ivfsheetsseemmen = R::findOne('icsisemen', 'id = ?', [$ivfsheet->sseemmen]);

        try {
            $ivfsheet->endpreg = 1;
            $ivfsheet->frozenor = $kind;
            $ivfsheet->historytoday = date("Y-m-d H:i:s");
            R::store($ivfsheet);
            $infertilitysheet = R::findOne('infertilitysheet', 'patientid = ?', [$patientid]);
            $tableadd = R::dispense('icsi');
            if ($kind == "frozen") {
                $tableadd->date = $ivfsheet->lmpfrozen;
                $tableadd->fert = $ivfsheet->fefn;
                $tableadd->et = $ivfsheet->etn;
                $tableadd->fr = $ivfsheet->frren;
                $tableadd->refr = $ivfsheet->refren;
                $tableadd->icsiss = $ivfsheet->ssnofte;
                $tableadd->icsiresult = $ivfsheet->outcomehsgn;
            } else {
                $tableadd->date = $ivfsheet->lmpfresh;
                $tableadd->icsisemen = $ivfsheetsseemmen->title;
                $tableadd->opu = $ivfsheet->opun;
                $tableadd->fert = $ivfsheet->fefn;
                $tableadd->et = $ivfsheet->ettn;
                $tableadd->fr = $ivfsheet->frren;
                $tableadd->icsiss = $ivfsheet->sssnofte;
                $tableadd->icsiresult = $ivfsheet->ooutcomehsgn;
                $tableadd->vd = $ivfsheet->ssscd;
            }
            $tableadd->icsiprotocol = $ivfsheetanprotocol->title;
            $tableadd->infertilitysheetid = $infertilitysheet->id;
            R::store($tableadd);



            echo 2;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function ovstcdfh() {
        $id = filter_input(INPUT_POST, 'id');
        $value = filter_input(INPUT_POST, 'value');
        $table = filter_input(INPUT_POST, 'table');
        $lmpfresh = filter_input(INPUT_POST, 'lmpfresh');
        $tableadd = R::load($table, $id);
        if ($table == "ovst") {
            $tableadd->ovstcdfh = $value + 1;
            $tableadd->ovstdate = date("Y/m/d", strtotime("$lmpfresh +$value day"));
        }
        R::store($tableadd);
        echo date("Y/m/d", strtotime("$lmpfresh +$value day"));
    }

    public function newcd() {
        $id = filter_input(INPUT_POST, 'id');
        $value = filter_input(INPUT_POST, 'value');
        $table = filter_input(INPUT_POST, 'table');
        $name = filter_input(INPUT_POST, 'name');
        $datename = filter_input(INPUT_POST, 'datename');
        $lmpf = filter_input(INPUT_POST, 'lmpf');
        $date = date("Y/m/d", strtotime("$lmpf +$value day"));
        $nvalue = $value + 1;

        try {
            $add = R::exec("update $table set $name = '" . $nvalue . "', $datename = '" . $date . "' where id = $id");
            echo date("Y/m/d", strtotime("$lmpf +$value day"));
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function archive() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize


        $patientid = filter_input(INPUT_GET, "patientid");

        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }

        $patient = R::load('patients', $patientid);
        $this->smarty->assign('patient', $patient);
        $this->smarty->assign('patientid', $patientid);

        // ancsheet
        $ivfsheet = R::findAll('ivfsheet', 'patientid = ? and endpreg = 1 order by id desc', [$patientid]);
        $this->smarty->assign('ivfsheet', $ivfsheet);



        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->display('ivfsheet/archive.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function historys() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize


        $ivfsheetid = filter_input(INPUT_GET, "ivfsheetid");
        $patientid = filter_input(INPUT_GET, "patientid");

        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }

        $patient = R::load('patients', $patientid);
        $this->smarty->assign('patient', $patient);

        // ancsheet
        $ivfsheet = R::findOne('ivfsheet', 'id = ?', [$ivfsheetid]);
        // ancsheet

        $id = $ivfsheet->id;
        $this->smarty->assign('id', $id);
        $this->smarty->assign('ivfsheet', $ivfsheet);
        $investigations = R::findAll('investigations', 'ancsheetid = ?', [$id]);
        $this->smarty->assign('investigations', $investigations);
        $ovst = R::findAll('ovst', 'ivfsheetid = ?', [$id]);
        $this->smarty->assign('ovst', $ovst);
        $eprep = R::findAll('eprep', 'ivfsheetid = ?', [$id]);
        $this->smarty->assign('eprep', $eprep);

        $infertilitysheet = R::findOne('infertilitysheet', 'patientid = ?', [$patientid]);
        $infertilitysheetid = $infertilitysheet->id;
        $this->smarty->assign('infertilitysheetid', $infertilitysheetid);
        $this->smarty->assign('infertilitysheet', $infertilitysheet);
        $wifep = R::findAll('wifep', 'infertilitysheetid = ?', [$infertilitysheetid]);
        $this->smarty->assign('wifep', $wifep);
        $wifeepc = R::findAll('wifeepc', 'infertilitysheetid = ?', [$infertilitysheetid]);
        $this->smarty->assign('wifeepc', $wifeepc);


        $gynasheet = R::findOne('gynasheet', 'patientid = ?', [$patientid]);
        $gynasheetid = $gynasheet->id;
        $this->smarty->assign('gynasheetid', $gynasheetid);
        $this->smarty->assign('gynasheet', $gynasheet);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->display('ivfsheet/ivfhistory.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function append() {


        $tablename = filter_input(INPUT_POST, 'tablename');
        $tablep = filter_input(INPUT_POST, 'tablep');
        $id = filter_input(INPUT_POST, 'id');
        $tablenameappend = R::dispense($tablename);
        $tablenameappend->$tablep = $id;
        $tablenameappendid = R::store($tablenameappend);


        $this->smarty->assign('tablename', $tablename);
        $this->smarty->assign('id', $tablenameappendid);
        $this->smarty->display('Ivfsheet/append.html');
    }

    public function getselectajax() {
        //check login
        autho::checkautho($this->hosturl);

        $newterm = filter_input(INPUT_POST, 'newterm');
        $celtable = filter_input(INPUT_POST, 'celtable');

        $tableadd = R::dispense($celtable);
        $tableadd->title = $newterm;
        $tableadd->del = null;
        $inserted = R::store($tableadd);
        echo $inserted;
    }

    public function getselect() {
        //check login
        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, 'id');
        $tablep = filter_input(INPUT_POST, 'tablep');
        $celtable = filter_input(INPUT_POST, 'celtable');
        $name = filter_input(INPUT_POST, 'name');
        $selid = filter_input(INPUT_POST, 'selid');
        $kind = filter_input(INPUT_POST, 'kind');
        $tablep = R::load($tablep, $selid);
        $celtable = R::findAll($celtable, 'del is null');
        $this->smarty->assign('tablep', $tablep);
        $this->smarty->assign('arrays', explode(',', $tablep->$name));
        $this->smarty->assign('celtable', $celtable);
        $this->smarty->assign('name', $name);
        $this->smarty->assign('id', $id);
        $this->smarty->assign('kind', $kind);
        $this->smarty->assign('selid', $selid);
        $this->smarty->display('Ivfsheet/select.html');
    }

    public function getdataselect() {
        //check login
        autho::checkautho($this->hosturl);

        $celtable = filter_input(INPUT_POST, 'celtable');
        $allceltable = R::findAll($celtable, 'del is null');
        $count = R::count($celtable, 'del is null');
        if ($count < 1) {
            echo "0";
            exit();
        }
        $this->smarty->assign('celtable', $celtable);
        $this->smarty->assign('allceltable', $allceltable);
        $this->smarty->display('Ivfsheet/delselect.html');
    }

    public function deldataselect() {
        //check login
        autho::checkautho($this->hosturl);

        $table = filter_input(INPUT_POST, 'table');
        $id = filter_input(INPUT_POST, 'id');
        $celtables = R::load($table, $id);
        $celtables->del = 1;
        try {
            $inserted = R::store($celtables);
            echo $inserted;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function addnewselect() {
        //check login
        autho::checkautho($this->hosturl);

        $table = filter_input(INPUT_POST, 'table');
        $celtables = R::dispense($table);
        $celtables->title = $newterm;
        $inserted = R::store($celtables);
        $out = '<tr id="remove_' . $inserted . '">
                  <td style="width: 100%">
                    <input class="form-control "  type="text"  name="title" data-id="' . $inserted . '"  data-table="' . $table . '" value="" >
                  </td>
                  <td>
                     <a href="#" style="width: 100%" class="btn red fleft deleteselect" data-table="' . $table . '" data-id="' . $inserted . '">
                     <i class="fa fa-times" ></i>
                     </a>
                  </td>
               </tr>';
        echo $out;
    }

    public function deleterow() {
        //check login
        autho::checkautho($this->hosturl);

        $table = filter_input(INPUT_POST, 'tablep');
        $id = filter_input(INPUT_POST, 'id');
        $celtables = R::load($table, $id);
        try {
            R::trash($celtables);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
