<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $patientid;
    public $time;
    public $today;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        //include PHPExcel library
        require_once "Classes/PHPExcel/IOFactory.php";

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;
        $this->today = date("Y-m-d");

//here name of controll to known
        $this->controllname = 'patienthistory';
        $this->shcontrollname = 'patienthistory';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'Patient History'; //controller name or tab name
        $active[1] = 'Patient History'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':
                $active[2] = 'show';
                break;
            case 'show':
                $active[2] = 'show';
                break;
            default :
                $active[2] = 'show';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

//here will call all php pages
        //here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
        $this->patientid = patientdata::patientid();
        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

//here the frist page and
//the frist action in this class

    public function index() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        if (empty($this->patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $del = 0;

        $patientwholedata = R::findOne('patients', 'id = ?', [$this->patientid]);
        $this->smarty->assign('patientwholedata', $patientwholedata);
        $statusNo = $patientwholedata->statusno;

        if ($ProgramesettingData->simpleview == 1) {
            ### simplediagnosis
            $simpleDiagnosis = R::findall('simplediagnosis', 'del = 0 order by date desc');

            foreach ($simpleDiagnosis as $record) {
                $record->date = date("d-m-Y", strtotime($record->date));
            }

            $this->smarty->assign('simpleDiagnosis', $simpleDiagnosis);
        } else {
            ### phregualrity
            $allphregualrity = R::findall('phregularity', 'del = 0 order by name');
            $this->smarty->assign('allphregualrity', $allphregualrity);

            ### phamount
            $allphamount = R::findall('phamount', 'del = 0 order by name');
            $this->smarty->assign('allphamount', $allphamount);

            ### phdysmenorrhoea
            $allphdysmenorrhoea = R::findall('phdysmenorrhoea', 'del = 0 order by name');
            $this->smarty->assign('allphdysmenorrhoea', $allphdysmenorrhoea);

            ### phmenstural for patient
            $allphmenstrual = R::findall('phmenstrual', 'del = ? and patientid = ? order by phl_mp  DESC, id desc', [$del, $this->patientid]);

            foreach ($allphmenstrual as $myallphmenstrual) {

                $userData = R::getRow('select user_name from awusers where user_id = ' . $myallphmenstrual->doctorid);
                $myallphmenstrual->username = $userData['user_name'];

                $myallphmenstrual->phlMP = date('Y/m/d', strtotime($myallphmenstrual->phlMP));
            }
            $this->smarty->assign('allphmenstrualcount', count($allphmenstrual));
            $this->smarty->assign('allphmenstrual', $allphmenstrual);

            /* ============================ph contraction ======================== */
            $allphcontracttype = R::findall('phcontracttype', 'del = 0 order by name');
            $this->smarty->assign('allphcontracttype', $allphcontracttype);
            //R::debug(true);
            $allcontract = R::findall('phcontraception', 'del = ? and patientid = ? order by id DESC', [$del, $this->patientid]);

            foreach ($allcontract as $myallcontract) {

                $userData = R::getRow('select user_name from awusers where user_id = ' . $myallcontract->doctorid);
                $myallcontract->username = $userData['user_name'];
            }
            $this->smarty->assign('allcontractcount', count($allcontract));
            $this->smarty->assign('allcontract', $allcontract);

            /* ===============================phobstetric ======================== */
            $allphobstericterminate = R::findall('phobstericterminate', 'del = 0 order by name');
            $this->smarty->assign('allphobstericterminate', $allphobstericterminate);

            $allphobstericterplace = R::findall('phobstericterplace', 'del = 0 order by name');
            $this->smarty->assign('allphobstericterplace', $allphobstericterplace);

            $allobsteric = R::findall('phobstetric', 'del = ? and patientid = ? order by obsdate desc, id DESC', [$del, $this->patientid]);
            foreach ($allobsteric as $myallobsteric) {
                $userData = R::getRow('select user_name from awusers where user_id = ' . $myallobsteric->doctorid);
                $myallobsteric->username = $userData['user_name'];
                $myallobsteric->obsdate = date('Y/m/d', strtotime($myallobsteric->obsdate));
            }
            $this->smarty->assign('allobstericcount', count($allobsteric));
            $this->smarty->assign('allobsteric', $allobsteric);

            /* =================================phpastmedicaldisease   ====================================== */
            ### phpastmedicaldisease
            $allphpastmedicaldisease = R::findall('phpastmedicaldisease', 'del = 0 order by name');
            $this->smarty->assign('allphpastmedicaldisease', $allphpastmedicaldisease);

            //$allpastmedical = R::findall('phpastmedical', 'del = ? and patientid = ? order by id DESC', [$del, $this->patientid]);
            $mypastmedical = R::findall('phpastmedical', 'del = ? and patientid = ? order by id DESC', [0, $this->patientid]);
            foreach ($mypastmedical as $myallpastmedical) {
                $userData = R::getRow('select user_name from awusers where user_id = ' . $myallpastmedical->doctorid);
                $myallpastmedical->username = $userData['user_name'];
            }
            $this->smarty->assign('phpastmedicalcount', count($mypastmedical));
            $this->smarty->assign('mypastmedical', $mypastmedical);

            /* =====================phpastsurgical =============================================================================================== */
            ### phpastsurgical operation
            $allphpastsurgicaloperation = R::findall('phpastsurgicaloperation', 'del = 0 order by name');
            $this->smarty->assign('allphpastsurgicaloperation', $allphpastsurgicaloperation);

            //$allpastsurgical = R::findall('phpastsurgical', 'del = ? and patientid = ? order by id DESC', [$del, $this->patientid]);
            $pastsurgical = R::findall('phpastsurgical', 'del = ? and patientid = ? order by phsurgicalyear desc, id DESC', [0, $this->patientid]);
            foreach ($pastsurgical as $myallpastsurgical) {
                $userData = R::getRow('select user_name from awusers where user_id = ' . $myallpastsurgical->doctorid);
                $myallpastsurgical->username = $userData['user_name'];
            }


            $this->smarty->assign('pastsurgicalcount', count($pastsurgical));
            $this->smarty->assign('pastsurgical', $pastsurgical);

            /* =====================phpastgynecological =============================================================================================== */
            ### phpastgynecological operation
            $allphpastgynecologicaloperation = R::findall('phpastgynecologicaloperation', 'del = 0 order by name');
            $this->smarty->assign('allphpastgynecologicaloperation', $allphpastgynecologicaloperation);

            //$allphpastgynecological = R::findall('phpastgynecological', 'del = ? and patientid = ? order by id DESC', [$del, $this->patientid]);
            $phpastgynecological = R::findall('phpastgynecological', 'del = ? and patientid = ? order by gynecologicalyear desc,  id DESC', [0, $this->patientid]);
            foreach ($phpastgynecological as $myallphpastgynecological) {
                $userData = R::getRow('select user_name from awusers where user_id = ' . $myallphpastgynecological->doctorid);
                $myallphpastgynecological->username = $userData['user_name'];
            }
            $this->smarty->assign('phpastgynecologicalcount', count($phpastgynecological));
            $this->smarty->assign('phpastgynecological', $phpastgynecological);

            /* =====================phpastarttype =============================================================================================== */
            ### phpastarttype
            $allphpastarttype = R::findall('phpastarttype', 'del = 0 order by name');
            $this->smarty->assign('allphpastarttype', $allphpastarttype);

            ### phpastarttype
            $allphpastartcenter = R::findall('phpastartcenter', 'del = 0 order by name');
            $this->smarty->assign('allphpastartcenter', $allphpastartcenter);

            //$allphpastart = R::findall('phpastart', 'del = ? and patientid = ? order by id DESC', [$del, $this->patientid]);
            $phpastart = R::findall('phpastart', 'del = ? and patientid = ? order by artyear desc, id DESC', [0, $this->patientid]);
            foreach ($phpastart as $myallphpastart) {
                $userData = R::getRow('select user_name from awusers where user_id = ' . $myallphpastart->doctorid);
                $myallphpastart->username = $userData['user_name'];
                if ($myallphpastart->arttype == 2 || $myallphpastart->arttype == 3) {
                    if ($myallphpastart->ovdate)
                        $myallphpastart->ovdate = date("Y/m/d", strtotime($myallphpastart->ovdate));
                    if ($myallphpastart->emdate)
                        $myallphpastart->emdate = date("Y/m/d", strtotime($myallphpastart->emdate));
                    if ($myallphpastart->freezdate)
                        $myallphpastart->freezdate = date("Y/m/d", strtotime($myallphpastart->freezdate));
                }


                //get new art
                $icsidata = R::findOne('phpasticsi', 'partentid= ?', [$myallphpastart->id]);
                $myallphpastart->icsiopu = $icsidata->opu;
                $myallphpastart->icsigii = $icsidata->gii;
                $myallphpastart->icsigi = $icsidata->gi;
                $myallphpastart->icsigv = $icsidata->gv;
                $myallphpastart->icsiet = $icsidata->et;
                $myallphpastart->icsietf = $icsidata->etf;
                $myallphpastart->icsifrozen = $icsidata->frozen;
                $myallphpastart->icsibhcg = $icsidata->bhcg;
                $myallphpastart->icsifhr = $icsidata->fhr;
                $myallphpastart->icsinotes = $icsidata->notes;
                $myallphpastart->icsiid = $icsidata->id;
            }
            $this->smarty->assign('phpastartcount', count($phpastart));
            $this->smarty->assign('phpastart', $phpastart);

            $this->internalArt($this->patientid);

            /* =====================phfamily =============================================================================================== */
            ### phfamilydisease
            $allphfamilydisease = R::findall('phfamilydisease', 'del = 0 order by name');
            $this->smarty->assign('allphfamilydisease', $allphfamilydisease);

            ### phfamilyrelative
            $allphfamilyrelative = R::findall('phfamilyrelative', 'del = 0 order by name');
            $this->smarty->assign('allphfamilyrelative', $allphfamilyrelative);

            //$allphfamily = R::findall('phfamily', 'del = ? and patientid = ? order by id DESC', [$del, $this->patientid]);
            $phfamily = R::findall('phfamily', 'del = ? and patientid = ? order by id DESC', [0, $this->patientid]);
            foreach ($phfamily as $myallphfamily) {
                $userData = R::getRow('select user_name from awusers where user_id = ' . $myallphfamily->doctorid);
                $myallphfamily->username = $userData['user_name'];
            }


            $this->smarty->assign('phfamilycountx', count($phfamily));
            $this->smarty->assign('phfamily', $phfamily);
        }


        $this->smarty->assign('patientId', $this->patientid);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        if ($ProgramesettingData->simpleview == 1) {
            $this->smarty->display('patienthistory/addsimple.html');
        } else {
            $this->smarty->display('patienthistory/add.html');
        }

        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);

        exec("$ProgramesettingData->phppath\php excel.php > out.txt 2> err.txt &");
        $this->checkpatientlist($statusNo);
    }

    private function internalArt($patientid) {
        ## load all completed monitoring sheets
        #
        $monitorSheets = R::findAll('mointoringsheet', 'status = 1 AND patientid = ? and deleted = 0 
                  order by monitordate desc ', [$patientid]);
        foreach ($monitorSheets as $data) {
            $data->monitordate = date("Y/m/d", strtotime($data->monitordate));
            ##
            #
            $procedure = R::load('mointoringsheetprocedure', $data->procedure);
            $data->procedure = $procedure->name;

            ##
            #
            $protocol = R::load('mointoringsheetprotocol', $data->protocol);
            $data->protocol = $protocol->name;
        }
        $this->smarty->assign('monitorSheets', $monitorSheets);
    }

    private function checkpatientlist($statusNo) {
        //check login
        //autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientList = R::findAll('excelinfopatients', 'patientid = ?', [$this->patientid]);

        if (count($patientList) <= 0) {    ## not exist then add it
            $excelInfoPatient = R::dispense('excelinfopatients');
            $excelInfoPatient->patientid = $this->patientid;
            $excelInfoPatient->statusno = $statusNo;
            R::store($excelInfoPatient);
        }
    }

    public function addnewmenstural() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $doctorid = $_SESSION['user_id'];
        $patientid = filter_input(INPUT_GET, "id");
        $itr = filter_input(INPUT_POST, "itr");
        $phmenstrual_obj = R::dispense('phmenstrual');
        $phmenstrual_obj->patientid = $patientid;
        $phmenstrual_obj->doctorid = $doctorid;
        $phmenstrual_obj->sysdate = $this->today;
        $phmenstrual_obj->menarche = '';
        $phmenstrual_obj->duration = '';
        $phmenstrual_obj->length = '';
        $phmenstrual_obj->phregularity = '';
        $phmenstrual_obj->phamount = '';
        $phmenstrual_obj->phdysmenorrhoea = '';
        $phmenstrual_obj->phlMP = $this->today;
        $phmenstrual_obj->del = 0;

        //call other class with other content

        $id = R::store($phmenstrual_obj);
        //echo $id;
        $phmenstrual_obj->id = $id;
        $phmenstrual_obj->phlMP = date('Y/m/d', strtotime($this->today));

        ### phregualrity
        $allphregualrity = R::findall('phregularity', 'del = 0');
        $this->smarty->assign('allphregualrity', $allphregualrity);

        ### phamount
        $allphamount = R::findall('phamount', 'del = 0');
        $this->smarty->assign('allphamount', $allphamount);

        ### phdysmenorrhoea
        $allphdysmenorrhoea = R::findall('phdysmenorrhoea', 'del = 0');
        $this->smarty->assign('allphdysmenorrhoea', $allphdysmenorrhoea);

        $this->smarty->assign('phmenstrual_obj', $phmenstrual_obj);
        $this->smarty->assign('itr', $itr);

        $userData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $username = $userData['user_name'];
        $this->smarty->assign('username', $username);

        $this->smarty->display('patienthistory/newMenstrualRow.html');
    }

    /* ===================================regularity =================================== */

    public function addRegualrity() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');
        ### insert into table
        $newtable = R::dispense('phregularity');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        ### update select in phmenstural for patient
        $mydata = R::findone('phmenstrual', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->phregularity = $insertid;
        R::store($mydata);
    }

    /* ==================================amount=========================== */

    public function addPhamount() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phamount');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        ### update select in phmenstural for patient
        $mydata = R::findone('phmenstrual', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->phamount = $insertid;
        R::store($mydata);
    }

    /* ==================================dysmenorrhoea=========================== */

    public function addphdysmenorrhoea() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phdysmenorrhoea');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        ### update select in phmenstural for patient
        $mydata = R::findone('phmenstrual', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->phdysmenorrhoea = $insertid;
        R::store($mydata);
    }

    public function update() {


        $id = filter_input(INPUT_POST, "id");
        $pareid = filter_input(INPUT_POST, "pareid");
        $value = filter_input(INPUT_POST, "value");
        $tableName = filter_input(INPUT_POST, "tableName");
        $colName = filter_input(INPUT_POST, "colName");
        $patientId = filter_input(INPUT_POST, "patientId");

        $dated = filter_input(INPUT_POST, "dated");

        if ($dated == 1) {
            $value = date("Y-m-d", strtotime($value));
        }



        if ($tableName == 'phpasticsi') {
            if (!empty($id)) {
                echo 0;
                $mydata = R::load($tableName, $id);
            } else {
                $mydata = R::findOne($tableName, 'partentid = ?', [$pareid]);
                $cmydata = R::count($tableName, 'partentid = ?', [$pareid]);
                if ($cmydata <= 0) {
                    $mydata = R::dispense($tableName);
                }
            }
            $mydata->$colName = $value;
            $mydata->patientid = $patientId;
            $mydata->partentid = $pareid;
            R::store($mydata);
        } else {
            $mydata = R::load($tableName, $id);
            $mydata->$colName = $value;
            $mydata->patientid = $patientId;
            R::store($mydata);
        }


        if ($colName == "outcomeid") {
            $colname = "babygendernew";
            if ($value == 1) {
                $val = 1;
            } else {
                $val = 0;
            }

            $mydata = R::load($tableName, $id);
            $mydata->$colname = $val;
            R::store($mydata);
        }
    }

    public function updateAjax() {

        //check login
        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, "id");
        $tablename = filter_input(INPUT_POST, "tableName");
        $colname = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");

        try {
            $obj = R::load($tablename, $id);
            $obj->$colname = $value;
            R::store($obj);
            echo 1;
        } catch (Exception $ex) {
            echo -1;
        }
    }

    public function editselect() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $tableName = filter_input(INPUT_POST, "tableName");
        $itr = filter_input(INPUT_POST, "itr");
        $name = filter_input(INPUT_POST, "name");
        $patientid = filter_input(INPUT_POST, "patientid");
        $rowoftableid = filter_input(INPUT_POST, "rowoftableid");
        $maintableName = filter_input(INPUT_POST, "maintableName");

        $alldata = R::findAll($tableName, 'del = 0');

        // print_r($mydata);
        $this->smarty->assign('tablename', $tableName);
        $this->smarty->assign('itr', $itr);
        $this->smarty->assign('selectname', $name);
        $this->smarty->assign('alldata', $alldata);
        $this->smarty->assign('patientid', $patientid);
        $this->smarty->assign('rowoftableid', $rowoftableid);
        $this->smarty->assign('maintableName', $maintableName);

        $this->smarty->display('patienthistory/editmodel.html');
    }

    public function updateselect() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $tableName = filter_input(INPUT_POST, "tablename");
        $value = filter_input(INPUT_POST, "value");
        $id = filter_input(INPUT_POST, "id");
        $patientId = filter_input(INPUT_POST, "patientid");
        $rowoftableid = filter_input(INPUT_POST, "rowoftableid");
        $selectname = filter_input(INPUT_POST, "selectname");
        $maintableName = filter_input(INPUT_POST, "maintableName");

        $mydata = R::findone($tableName, 'id = ? ', [$id]);
        $mydata->name = $value;
        R::store($mydata);

        ### update select in phmenstural for patient
        $myalldata = R::findone($maintableName, 'id = ? and patientid = ?', [$rowoftableid, $patientId]);
        $myalldata->$selectname = $id;
        R::store($myalldata);
    }

    public function delRows() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");
        try {
            $myData = R::load($tableName, $id);
            $myData->del = 1;
            $myid = R::store($myData);

            echo 1;
            //header('Location:' . $this->hosturl . '/controllers/' . $this->controllname.'.php?ac=index' );
        } catch (Exception $e) {
            //header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function delRowsommedel() {

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");

        $myData = R::load($tableName, $id);
        $myData->del = 1;
        $myid = R::store($myData);

        echo 1;
        //  header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php');
    }

    /* =========================================constration ==================== */

    public function addnewconstract() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $doctorid = $_SESSION['user_id'];
        $patientid = filter_input(INPUT_GET, "id");
        $itr = filter_input(INPUT_POST, "itr");
        $phconstract_obj = R::dispense('phcontraception');
        $phconstract_obj->patientid = $patientid; //
        $phconstract_obj->doctorid = $doctorid;
        $phconstract_obj->sysdate = $this->today;
        $phconstract_obj->contype = '';
        $phconstract_obj->contduration = '';
        $phconstract_obj->contstopped = '';
        $phconstract_obj->contranote = '';
        $phconstract_obj->del = 0;

        //call other class with other content

        $id = R::store($phconstract_obj);
        $phconstract_obj->id = $id;

        ### phregualrity
        $allphcontracttype = R::findall('phcontracttype', 'del = 0');
        $this->smarty->assign('allphcontracttype', $allphcontracttype);

        $userData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $username = $userData['user_name'];
        $this->smarty->assign('username', $username);

        $this->smarty->assign('phconstract_obj', $phconstract_obj);
        $this->smarty->assign('itr', $itr);

        $this->smarty->display('patienthistory/newContractRow.html');
    }

    public function addphcontype() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phcontracttype');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        ### update select in phcontractt for patient
        $mydata = R::findone('phcontraception', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->contype = $insertid;
        R::store($mydata);
    }

    /* ================================obsteric============================== */

    public function addnewobstetric() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $doctorid = $_SESSION['user_id'];
        $patientid = filter_input(INPUT_GET, "id");

        $lastObst = R::findOne('phobstetric', 'del = 0 and patientid = ? order by id desc limit 1', [$patientid]);

        $patientid = filter_input(INPUT_GET, "id");
        $itr = filter_input(INPUT_POST, "itr");
        $phobstetric_obj = R::dispense('phobstetric');
        $phobstetric_obj->patientid = $patientid; //
        $phobstetric_obj->doctorid = $doctorid; //
        $phobstetric_obj->sysdate = $this->today;
        $phobstetric_obj->obstrduration = '';
        $phobstetric_obj->obstermination = '';
        $phobstetric_obj->obsplace = '';
        $phobstetric_obj->obsdate = $this->today;
        $phobstetric_obj->obsnote = '';
        $phobstetric_obj->outcomeid = 0;
        $phobstetric_obj->babytype = 0;
        $phobstetric_obj->babygendernew = 0;
        $phobstetric_obj->babyweight = '';
        $phobstetric_obj->babyname = '';
        $phobstetric_obj->babytype1 = 0;
        $phobstetric_obj->babygendernew1 = 0;
        $phobstetric_obj->babyweight1 = '';
        $phobstetric_obj->babyname1 = '';
        $phobstetric_obj->babytype2 = 0;
        $phobstetric_obj->babygendernew2 = 0;
        $phobstetric_obj->babyweight2 = '';
        $phobstetric_obj->babyname2 = '';
        $phobstetric_obj->del = 0;

        //call other class with other content

        $id = R::store($phobstetric_obj);
        $phobstetric_obj->id = $id;
        $phobstetric_obj->obsdate = date('Y/m/d', strtotime($phobstetric_obj->obsdate));

        $allphobstericterminate = R::findall('phobstericterminate', 'del = 0');
        $this->smarty->assign('allphobstericterminate', $allphobstericterminate);

        $allphobstericterplace = R::findall('phobstericterplace', 'del = 0');
        $this->smarty->assign('allphobstericterplace', $allphobstericterplace);

        $userData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $username = $userData['user_name'];
        $this->smarty->assign('username', $username);

        $this->smarty->assign('phobstetric_obj', $phobstetric_obj);
        $this->smarty->assign('itr', $itr);
        $this->smarty->display('patienthistory/newObstetricRow.html');
    }

    public function addphobstericterminate() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phobstericterminate');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        ### update select in phobstetric for patient
        $mydata = R::findone('phobstetric', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->obstermination = $insertid;
        R::store($mydata);
    }

    public function addphobstericterplace() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phobstericterplace');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        ### update select in phobstetric for patient
        $mydata = R::findone('phobstetric', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->obsplace = $insertid;
        R::store($mydata);
    }

    /* ===============================================pasth ==================================================== */

    public function addnewpasthmedical() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $doctorid = $_SESSION['user_id'];
        $patientid = filter_input(INPUT_GET, "id");
        $itr = filter_input(INPUT_POST, "itr");
        $phpastmedical_obj = R::dispense('phpastmedical');
        $phpastmedical_obj->patientid = $patientid; //
        $phpastmedical_obj->doctorid = $doctorid; //
        $phpastmedical_obj->sysdate = $this->today;
        $phpastmedical_obj->medicaldisease = '';
        $phpastmedical_obj->medicalnote = '';
        $phpastmedical_obj->del = 0;

        //call other class with other content

        $id = R::store($phpastmedical_obj);
        $phpastmedical_obj->id = $id;

        ### phpastmedicaldisease
        $allphpastmedicaldisease = R::findall('phpastmedicaldisease', 'del = 0');
        $this->smarty->assign('allphpastmedicaldisease', $allphpastmedicaldisease);

        $userData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $username = $userData['user_name'];
        $this->smarty->assign('username', $username);

        $this->smarty->assign('phpastmedical_obj', $phpastmedical_obj);
        $this->smarty->assign('itr', $itr);
        $this->smarty->display('patienthistory/newPastMedicalRow.html');
    }

    public function addphpastmedical() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phpastmedicaldisease');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        ### update select in phobstetric for patient
        $mydata = R::findone('phpastmedical', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->medicaldisease = $insertid;
        R::store($mydata);
    }

    /* ===============================================past Surgicalh ==================================================== */

    public function addnewpasthsurgical() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $doctorid = $_SESSION['user_id'];
        $patientid = filter_input(INPUT_GET, "id");
        $itr = filter_input(INPUT_POST, "itr");
        $phpastsurgical_obj = R::dispense('phpastsurgical');
        $phpastsurgical_obj->patientid = $patientid; //
        $phpastsurgical_obj->doctorid = $doctorid;
        $phpastsurgical_obj->sysdate = $this->today;
        $phpastsurgical_obj->surgicaloperation = '';
        $phpastsurgical_obj->phsurgicalyear = '';
        $phpastsurgical_obj->phsurgicalsurgeon = '';
        $phpastsurgical_obj->surgicalnote = '';
        $phpastsurgical_obj->del = 0;

        //call other class with other content

        $id = R::store($phpastsurgical_obj);
        $phpastsurgical_obj->id = $id;

        ### phpastsurgical operation
        $allphpastsurgicaloperation = R::findall('phpastsurgicaloperation', 'del = 0');
        $this->smarty->assign('allphpastsurgicaloperation', $allphpastsurgicaloperation);

        $userData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $username = $userData['user_name'];
        $this->smarty->assign('username', $username);

        $this->smarty->assign('phpastsurgical_obj', $phpastsurgical_obj);
        $this->smarty->assign('itr', $itr);
        $this->smarty->display('patienthistory/newPastSurgicalRow.html');
    }

    public function addphpastsurgical() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phpastsurgicaloperation');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        ### update select in phobstetric for patient
        $mydata = R::findone('phpastsurgical', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->surgicaloperation = $insertid;
        R::store($mydata);
    }

    /* ===============================================past Surgicalh ==================================================== */

    public function addnewpastgynecological() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $doctorid = $_SESSION['user_id'];
        $patientid = filter_input(INPUT_GET, "id");
        $itr = filter_input(INPUT_POST, "itr");
        $phpastgynecological_obj = R::dispense('phpastgynecological');
        $phpastgynecological_obj->patientid = $patientid; //
        $phpastgynecological_obj->doctorid = $doctorid;
        $phpastgynecological_obj->sysdate = $this->today;
        $phpastgynecological_obj->gynecologicaloperation = '';
        $phpastgynecological_obj->gynecologicalyear = '';
        $phpastgynecological_obj->gynecologicalsurgeon = '';
        $phpastgynecological_obj->gynecologicalnote = '';
        $phpastgynecological_obj->del = 0;

        //call other class with other content

        $id = R::store($phpastgynecological_obj);
        $phpastgynecological_obj->id = $id;

        ### phpastgynecological operation
        $allphpastgynecologicaloperation = R::findall('phpastgynecologicaloperation', 'del = 0');
        $this->smarty->assign('allphpastgynecologicaloperation', $allphpastgynecologicaloperation);

        $userData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $username = $userData['user_name'];
        $this->smarty->assign('username', $username);

        $this->smarty->assign('phpastgynecological_obj', $phpastgynecological_obj);
        $this->smarty->assign('itr', $itr);
        $this->smarty->display('patienthistory/newPastgynecologicalRow.html');
    }

    public function addphgynecologicaloperation() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phpastgynecologicaloperation');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        $mydata = R::findone('phpastgynecological', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->gynecologicaloperation = $insertid;
        R::store($mydata);
    }

    /* ===============================================past art ==================================================== */

    public function addnewpastart() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $doctorid = $_SESSION['user_id'];

        $patientid = filter_input(INPUT_GET, "id");
        $itr = filter_input(INPUT_POST, "itr");
        $phpastart_obj = R::dispense('phpastart');
        $phpastart_obj->patientid = $patientid; //
        $phpastart_obj->doctorid = $doctorid;
        $phpastart_obj->sysdate = $this->today;
        $phpastart_obj->arttype = '';
        $phpastart_obj->artcenter = '';
        $phpastart_obj->artyear = '';
        $phpastart_obj->artnote = '';
        $phpastart_obj->del = 0;

        $id = R::store($phpastart_obj);
        $phpastart_obj->id = $id;

        ### phpastarttype
        $allphpastarttype = R::findall('phpastarttype', 'del = 0');
        $this->smarty->assign('allphpastarttype', $allphpastarttype);

        ### phpastarttype
        $allphpastartcenter = R::findall('phpastartcenter', 'del = 0');
        $this->smarty->assign('allphpastartcenter', $allphpastartcenter);

        $userData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $username = $userData['user_name'];
        $this->smarty->assign('username', $username);

        $this->smarty->assign('phpastart_obj', $phpastart_obj);
        $this->smarty->assign('itr', $itr);
        $this->smarty->display('patienthistory/newPastArtRow.html');
    }

    public function addphpastarttype() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $doctorid = $_SESSION['user_id'];

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phpastarttype');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        $mydata = R::findone('phpastart', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->arttype = $insertid;
        R::store($mydata);
    }

    public function addphpastartcenter() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phpastartcenter');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        $mydata = R::findone('phpastart', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->artcenter = $insertid;
        R::store($mydata);
    }

    /* =====================================family h ========================================================== */

    public function addnewFamily() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);

        $doctorid = $_SESSION['user_id'];

        $patientid = filter_input(INPUT_GET, "id");
        $itr = filter_input(INPUT_POST, "itr");
        $phfamily_obj = R::dispense('phfamily');
        $phfamily_obj->patientid = $patientid; //
        $phfamily_obj->doctorid = $doctorid;
        $phfamily_obj->sysdate = $this->today;
        $phfamily_obj->familyDisease = '';
        $phfamily_obj->familyRelative = '';
        $phfamily_obj->familynote = '';
        $phfamily_obj->del = 0;

        $id = R::store($phfamily_obj);
        $phfamily_obj->id = $id;

        ### phpastarttype
        $allphfamilydisease = R::findall('phfamilydisease', 'del = 0');
        $this->smarty->assign('allphfamilydisease', $allphfamilydisease);

        ### phpastarttype
        $allphfamilyrelative = R::findall('phfamilyrelative', 'del = 0');
        $this->smarty->assign('allphfamilyrelative', $allphfamilyrelative);

        $userData = R::getRow('select user_name from awusers where user_id = ' . $doctorid);
        $username = $userData['user_name'];
        $this->smarty->assign('username', $username);

        $this->smarty->assign('phfamily_obj', $phfamily_obj);
        $this->smarty->assign('itr', $itr);
        $this->smarty->display('patienthistory/newFamilyRow.html');
    }

    public function addphFamilyDisease() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phfamilydisease');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        $mydata = R::findone('phfamily', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->familyDisease = $insertid;
        R::store($mydata);
    }

    public function addphFamilyRelative() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'newitem');
        $inline = filter_input(INPUT_POST, 'inline');
        $selectid = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, 'id');

        ### insert into table
        $newtable = R::dispense('phfamilyrelative');
        $newtable->name = $name;
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;

        $mydata = R::findone('phfamily', 'id = ? and patientid = ?', [$selectid, $patientId]);
        $mydata->familyRelative = $insertid;
        R::store($mydata);
    }

    public function addNewRow() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $table = filter_input(INPUT_POST, 'tablename');

        ### insert into table
        $newtable = R::dispense($table);
        $newtable->del = 0;

        $insertid = R::store($newtable);

        echo $insertid;
    }

    ######################################################

    public function addRow() {
        //check login
        autho::checkautho($this->hosturl);

        $value = filter_input(INPUT_POST, 'value');
        $table = filter_input(INPUT_POST, 'table');

        if ($table == 'drugdos' || $table == 'drugtype' || $table == 'drugname') {
            $add = R::xdispense('drugs');
            $add->drugdos = ' ';
            $add->drugtype = ' ';
            $add->drugname = ' ';
            $add->drugcat = ' ';
            $add->$table = $value;
        } else {
            $add = R::xdispense($table);
            $add->name = $value;
            $add->deleted = 0;
        }
        $inserted = R::store($add);
        echo $inserted;
    }

// at the end of class call
    public function __destruct() {
        //echo "Time Elapsed: ".(microtime(true) - $this->time)."s";
//close connection
        R::close();
    }
}
