<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in structure of file
 */

require_once("imp/_imp.php");

class Controllers
{

    //public vars
    public $smarty;
    public $hosturl;
    public $controllName;
    public $shcontrollName;
    public $active;

    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions

        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'screen_orders';
        $this->shcontrollname = 'Screen orders';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'role'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':$active[1] = 'screenordersadd';
                break;
            case 'show':$active[1] = 'screenordershow';
                break;
            default :$active[1] = 'screenordershow';
                break;
        }
        $this->active = $active;

        //so I can use underscore in table's name
        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });


        //here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    public function index()
    {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        //autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //load all parents here
        $show_patients = $this->displayVisitsOrder($this->hosturl);
        $this->smarty->assign('show_patients', $show_patients);

        // get all sliders for screen
        $screen_slider = R::findAll('screen_slider');
        $this->smarty->assign('screen_slider', $screen_slider);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('screen_orders/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    //just use it to draw menu
    public function displayVisitsOrder($hosturl)
    {

       // R::selectDatabase('obgy');

        $visits_html = "";
        //get the all about this level in menu
        $result = R::getAll('SELECT * FROM visits WHERE deleted = 0 and visitdate = ? order by custom_order', [date('Y-m-d')]);

        foreach ($result as $single_visit) {

            $patient_info = R::getRow('select * from patients where id = ? ',[$single_visit['patientid']]);

            if((int)$single_visit['view'] === 0){
                $class_handle = 'dd-handle';
                $class_color = '';
            }else{
                $class_handle = '';
                $class_color = 'green';
            }

            $visits_html .= '<li class="dd-item dd3-item '.$class_color.'" data-id="' . $single_visit["id"] . '">';
            $visits_html .= '<div class="'.$class_handle.' dd3-handle"></div><div class="dd3-content">'
                . $patient_info['wifename']
//                . '<a data-id="' . $single_visit["id"] . '" data-link="_controll" class="btn grey-cascade btn-xs pull-right deletemsg mg_top"><i class="icon-logout"></i> خروج</a>'
//                . '<a href="' . $hosturl . '/_controll/edit/' . $single_visit["id"] . '" class="btn green btn-xs pull-right mg-rg margin-right-10"><i class="icon-login"></i> دخول</a>&nbsp;'
                . '</div>';
            $visits_html .= '</li>';
        }

        //R::selectDatabase('default');

        return $visits_html;
    }

    public function orderVisit()
    {
        //check login
        autho::checkautho($this->hosturl);

        $orderJson = filter_input(INPUT_POST, 'orderJson');
        $orderArr = json_decode($orderJson);


        $order = 1;
        foreach ($orderArr as $elem) {
            $visit = R::findOne('visits','id = ?', [$elem->id]);
            $visit->custom_order = $order;
            if ($visit) {
                R::store($visit);
                $order++;
            }
        }

    }

    public function uploadSlider()
    {
        //check login
        autho::checkautho($this->hosturl);

        require_once("../../_library/plugins/classupload/uploadfunctions.php");

        $image = uploadnew('file', False, 0, 0, 'screen_slider',false);

        $slider = R::xdispense('screen_slider');
        $slider->image = $image;
        $slider->create_date = date('Y-m-d');

        $id = R::store($slider);

        echo $id;

    }

    public function removeSlider()
    {
        //check login
        autho::checkautho($this->hosturl);

        $item_id = filter_input(INPUT_POST, 'id');

        $slider = R::findOne('screen_slider', 'id = ?',[$item_id]);

        if (file_exists('../../upload/screen_slider/' . $slider->image)) {
            //echo $imageNewName;
            chmod('../../upload/screen_slider/' . $slider->image, 0777);
            unlink('../../upload/screen_slider/' . $slider->image);
        }

        try {
            R::trash($slider);
            echo '1';
        } catch (Exception $e) {
            echo '0';
        }
    }

    public function patientLogout(){
        //check login
        autho::checkautho($this->hosturl);

        $result = R::findAll('visits',' deleted = 0 and visitdate = ? and view = 1 order by visitorder', [date('Y-m-d')]);
        foreach ($result as $item){
            $item->end_visit = 1;
            R::store($item);
        }

        header('Location:' . $this->hosturl . '/controllers/' . $this->controllname.'.php');

    }

    // at the end of class call
    public function __destruct()
    {
        //close connection
        R::close();
    }

}
