<?php

require_once("imp/_imp.php");

class Controllers
{
    public $smarty;
    public $host_url;
    public $control_name;
    public $display_control_name;
    public $active;
    public $time;
    public $today;
    public $patient_id;

    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->host_url = $hosturl;

        $this->control_name = 'vacations';
        $this->display_control_name = 'vacations';
        $this->smarty->assign('control_name', $this->control_name);
        $this->smarty->assign('display_control_name', $this->display_control_name);

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $active[0] = $this->control_name;
        $active[1] = $this->control_name;
        if($acty === ''){
            $active[2] = $this->control_name.'add';
        }else{
            $active[2] = $this->control_name.'show';
        }

        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        $this->smarty->display('vacations/add.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function add()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $row = R::dispense('vacations');
        $row->vacation_date = filter_input(INPUT_POST, 'vacation_date');
        $row->vacation_reason = filter_input(INPUT_POST, 'vacation_reason');
        $row->created_at = date('Y-m-d H:i:s');
        $row->updated_at = date('Y-m-d H:i:s');
        $row->created_by = $_SESSION['user_id'];
        $row->updated_by = $_SESSION['user_id'];
        try {
            R::store($row);
            header('Location:' . $this->host_url . '/controllers/' . $this->control_name . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/error/notadd/' . $this->control_name);
        }
    }

    public function show()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $vacations = R::findAll('vacations','vacation_date >= date("'.date('Y/m/d').'") ORDER BY vacation_date ASC');
        $this->smarty->assign('vacations', $vacations);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        $this->smarty->display('vacations/show.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function edit()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, 'id');
        $vacation = R::load('vacations', $id);
        $this->smarty->assign('vacation', $vacation);

        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        $this->smarty->display('vacations/edit.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    public function update()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');

        $row = R::load('vacations', $id);
        $row->vacation_date = filter_input(INPUT_POST, 'vacation_date');
        $row->vacation_reason = filter_input(INPUT_POST, 'vacation_reason');
        $row->updated_at = date('Y-m-d H:i:s');
        $row->updated_by = $_SESSION['user_id'];
        try {
            R::store($row);
            header('Location:' . $this->host_url . '/controllers/' . $this->control_name . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/error/notupdate/' . $this->control_name);
        }
    }

    public function del()
    {
        autho::checkautho($this->host_url);
        autho::checkauthoize($this->control_name, $this->host_url, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            $item = R::findOne('vacations', 'id = ?', [$id]);
            R::trash($item);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function __destruct()
    {
        R::close();
    }

}
