var Calendar = function () {
    return {
        init: function () {
            Calendar.initCalendar();
        }, initCalendar: function () {
            if (!jQuery().fullCalendar) {
                return;
            }
            var date = new Date();
            var d = date.getDate();
            var m = date.getMonth();
            var y = date.getFullYear();
            var h = {};
            if (Metronic.isRTL()) {
                if ($('#calendar').parents(".portlet").width() <= 720) {
                    $('#calendar').addClass("mobile");
                    h = {right: 'title, prev, next', center: '', left: 'agendaDay, agendaWeek, month, today'};
                } else {
                    $('#calendar').removeClass("mobile");
                    h = {right: 'title', center: '', left: 'agendaDay, agendaWeek, month, today, prev,next'};
                }
            } else {
                if ($('#calendar').parents(".portlet").width() <= 720) {
                    $('#calendar').addClass("mobile");
                    h = {left: 'title, prev, next', center: '', right: 'today,month,agendaWeek,agendaDay'};
                } else {
                    $('#calendar').removeClass("mobile");
                    h = {left: 'title', center: '', right: 'prev,next,today,month,agendaWeek,agendaDay'};
                }
            }
            var initDrag = function (el) {//
                var eventObject = {title: $.trim(el.text())};
                el.data('eventObject', eventObject);
                el.draggable({zIndex: 999, revert: true, revertDuration: 0});
            };
            var addEvent = function (title) {
                title = title.length === 0 ? "Untitled Event" : title;
                var html = $('<div class="external-event label label-default">' + title + '</div>');
                jQuery('#event_box').append(html);
                initDrag(html);
            };
            $('#external-events div.external-event').each(function () {
                initDrag($(this));
            });
            $('#event_add').unbind('click').click(function () {
                var title = $('#event_title').val();
                addEvent(title);
            });
            $('#event_box').html("");
            addEvent("My Event 1");
            addEvent("My Event 2");
            addEvent("My Event 3");
            addEvent("My Event 4");
            addEvent("My Event 5");
            addEvent("My Event 6");
            $('#calendar').fullCalendar('destroy');
            $('#calendar').fullCalendar({
                header: h,
                defaultView: 'month',
                slotMinutes: 15,
                editable: true,
                droppable: true,
                drop: function (date, allDay) {
                    var originalEventObject = $(this).data('eventObject');
                    var copiedEventObject = $.extend({}, originalEventObject);
                    copiedEventObject.start = date;
                    copiedEventObject.allDay = allDay;
                    copiedEventObject.className = $(this).attr("data-class");
                    $('#calendar').fullCalendar('renderEvent', copiedEventObject, true);
                    if ($('#drop-remove').is(':checked')) {
                        $(this).remove();
                    }
                },
                events: [{title: 'All Day Event', start: new Date(y, m, 1), backgroundColor: Metronic.getBrandColor('yellow')}, {
                    title: 'Long Event',
                    start: new Date(y, m, d - 5),
                    end: new Date(y, m, d - 2),
                    backgroundColor: Metronic.getBrandColor('green')
                }, {title: 'Repeating Event', start: new Date(y, m, d - 3, 16, 0), allDay: false, backgroundColor: Metronic.getBrandColor('red')}, {
                    title: 'Repeating Event',
                    start: new Date(y, m, d + 4, 16, 0),
                    allDay: false,
                    backgroundColor: Metronic.getBrandColor('green')
                }, {title: 'Meeting', start: new Date(y, m, d, 10, 30), allDay: false,}, {
                    title: 'Lunch',
                    start: new Date(y, m, d, 12, 0),
                    end: new Date(y, m, d, 14, 0),
                    backgroundColor: Metronic.getBrandColor('grey'),
                    allDay: false,
                }, {
                    title: 'Birthday Party',
                    start: new Date(y, m, d + 1, 19, 0),
                    end: new Date(y, m, d + 1, 22, 30),
                    backgroundColor: Metronic.getBrandColor('purple'),
                    allDay: false,
                }, {title: 'Click for Google', start: new Date(y, m, 28), end: new Date(y, m, 29), backgroundColor: Metronic.getBrandColor('yellow'), url: 'http://google.com/',}]
            });
        }
    };
}();